#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "qfiles.h"
#include "scriptlib.h"
#include "entity.h"

// 
// This file was originally part of the Quake2 source release.  
// I've modified the script library code to malloc of a shared
// memory arena.
//
// Rick
//

extern unsigned int _qkHashStr(const char *str);

#define true 1
#define false 0

//
// This code was lifted from the Quake2 source distribution, bspfile.c
//

char *copystring(char *s)
{
  char	*b;
  b = (char *)pfMalloc(strlen(s)+1, pfGetSharedArena());
  strcpy (b, s);
  return b;
}


void StripTrailing (char *e)
{
  char	*s;

  s = e + strlen(e)-1;
  while (s >= e && *s <= 32)
    {
      *s = 0;
      s--;
    }
}

/*
=================
ParseEpair
=================
*/
epair_t *ParseEpair (void)
{
  epair_t	*e;

  e = (epair_t *)pfMalloc (sizeof(epair_t), pfGetSharedArena());
	
  if (strlen(token) >= MAX_KEY-1)
    fprintf(stderr,"ParseEpar: token too long");
  e->key = copystring(token);
  e->ikey = _qkHashStr(e->key);
  GetToken (false);
  if (strlen(token) >= MAX_VALUE-1)
    fprintf (stderr, "ParseEpar: token too long");
  e->value = copystring(token);
  e->next = NULL;

  // strip trailing spaces
  StripTrailing (e->key);
  StripTrailing (e->value);

  return e;
}


/*
================
ParseEntity
================
*/
int	ParseEntity (quakeBsp *bsp)
{
  epair_t		*e;
  entity_t	*mapent;

  if (!GetToken (true))
    return false;

  if (strcmp (token, "{") )
    fprintf (stderr, "ParseEntity: { not found");
	
  if (bsp->num_entities == MAX_MAP_ENTITIES)
    fprintf (stderr, "num_entities == MAX_MAP_ENTITIES");

  mapent = &bsp->entities[bsp->num_entities];
  bsp->num_entities++;

  do
    {
      if (!GetToken (true))
	fprintf (stderr, "ParseEntity: EOF without closing brace");
      if (!strcmp (token, "}") )
	break;
      e = ParseEpair ();
      e->next = mapent->epairs;
      mapent->epairs = e;
    } while (1);
	
  return true;
}

void PrintEntity (entity_t *ent)
{
  epair_t	*ep;
	
  printf ("------- entity %p -------\n", ent);
  for (ep=ent->epairs ; ep ; ep=ep->next) {
    printf ("%s = %s\n", ep->key, ep->value);
  }

}
