/*
 ============================================================================
    $Revision: 1.0 $        $Date: 1997/11/20 15:01:26 $
 ============================================================================

                      PARADIGM SIMULATION, INCORPORATED
               Copyright (c) 1998 by Paradigm Simulation, Inc.

           This software is licensed and not sold. All use of this
           software is subject to the terms and conditions of the PSI
           software license, which should be read carefully. Copyright
           infringement is a serious and criminal offense.
           For more information, contact Paradigm Simulation at
           1-972-960-2301 or send e-mail to support@paradigmsim.com.

  ============================================================================
*/

// Force use of C API.
#define PF_CPLUSPLUS_API 0

// Uncomment to use post-draw callbacks to render lightmaps.
#define USE_PFGSTATE_CBS

#include "lighttex.h"
#include "qfiles.h"

qkLightMapHole::qkLightMapHole(GLushort x, GLushort y, GLushort w, GLushort h)
{
  _origin[0] = x;
  _origin[1] = y;
  _size[0] = w;
  _size[1] = h;
}

qkLightMapHole::~qkLightMapHole()
{

}

GLint qkLightMap::_count = 0;

static int _gstatePreApply(pfGeoState *gst, void *data)
{
  // PAUL!! - was commented
  // blend explain - do not multiply source by factor. Just take dest
  //   (what is in frame buffer) and factor by src.
  //  glPushAttrib(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glBlendFunc(GL_ZERO, GL_SRC_COLOR); 
  //glBlendFunc(GL_DST_COLOR, GL_ZERO); // new based on cq3a src
  //glDepthMask(0);
  glDepthFunc(GL_LEQUAL);
  //fprintf(stderr, ".");
  //fflush(stderr);
  return 0;
}

static int _gstatePostApply(pfGeoState *gst, void *data)
{
  //glDepthMask(1);
  //glPopAttrib(); // PAUL!!! - was commented
  return 0;
}

qkLightMap::qkLightMap()
{
  
  // Create the light map texture.

  _tex = pfNewTex(pfGetSharedArena());
  _gst = pfNewGState(pfGetSharedArena());

  pfTexEnv *tenv = pfNewTEnv(pfGetSharedArena());
  pfTEnvMode(tenv, GL_REPLACE);
  pfGStateAttr(_gst, PFSTATE_TEXENV, (void *)tenv);
 
  // Turn on transparency to force glEnable(GL_BLEND) to be called.
  pfGStateMode(_gst, PFSTATE_TRANSPARENCY, PFTR_BLEND_ALPHA);
  pfGStateMode(_gst, PFSTATE_ENTEXTURE, PF_ON);

  pfGStateAttr(_gst, PFSTATE_TEXTURE, _tex);
  pfGStateMode(_gst, PFSTATE_ENLIGHTING, PF_OFF);
  pfGStateMode(_gst, PFSTATE_CULLFACE, PFCF_FRONT);

#ifdef USE_PFGSTATE_CBS
  pfGStateFuncs(_gst, _gstatePreApply, _gstatePostApply, NULL);
#endif

  _image = (GLuint *)pfMalloc(sizeof(GLuint) * _lightmap_size * _lightmap_size, 
			      pfGetSharedArena());

  // Force image to cyan for debugging...
  GLuint *iptr;
  int i;
  for (i = 0, iptr = _image; i < _lightmap_size * _lightmap_size; i++, iptr++) {
    *iptr = 0x00FFFFFF;
  }

  pfTexImage(_tex, _image, 4, _lightmap_size, _lightmap_size, 1);
  pfTexFormat(_tex, PFTEX_IMAGE_FORMAT, PFTEX_RGBA);

  char name[PF_MAXSTRING];
  sprintf(name, "lm_%d", _count++);
  pfTexName(_tex, name);

  // Create the first hole covering the entire image.

  _holes = pfNewList(sizeof(qkLightMapHole *), 2, pfGetSharedArena());

  qkLightMapHole *hole = 
    new qkLightMapHole(0, 0, _lightmap_size, _lightmap_size);

  pfAdd(_holes, (void *)hole);
}

qkLightMap::~qkLightMap()
{
  pfFree(_image);
  pfDelete(_tex);

  int num_holes = pfGetNum(_holes);
  for (int i = 0; i < num_holes; i++) {
    qkLightMapHole *hole = (qkLightMapHole *)pfGet(_holes, i);
    delete hole;
  }
  pfDelete(_holes);
}

int qkLightMap::addMap(GLushort width, GLushort height, GLubyte *image, 
		       GLushort *origin_x, GLushort *origin_y)
{

  qkLightMapHole *best_fit = _findBestFit(width, height);

  if (best_fit == NULL) return FALSE;

  GLushort bf_w, bf_h, bf_x, bf_y;

  best_fit->getSize(&bf_w, &bf_h);
  best_fit->getOrigin(&bf_x, &bf_y);

  if (bf_w == width && bf_h == height) {

    // This hole is a perfect fit.  Fill it in.
    _copyImage(image, width, height, bf_x, bf_y);

    // Delete this hole from the list.
    pfFastRemove(_holes, (void *)best_fit);
    delete best_fit;

  } else {

    // Stuff image at origin of this hole.
    _copyImage(image, width, height, bf_x, bf_y);

    // Create new holes.
    // Add new holes to list.
    if ((bf_h - height) > (bf_w - width)) {
      qkLightMapHole *new_hole = new qkLightMapHole(bf_x, bf_y + height, bf_w,
						    bf_h - height);
      pfAdd(_holes, (void *)new_hole);

      // Reuse best_fit hole.
      best_fit->setOrigin(bf_x + width, bf_y);
      best_fit->setSize(bf_w - width, height);
    } else {
      qkLightMapHole *new_hole = new qkLightMapHole(bf_x + width, bf_y, 
						    bf_w - width, bf_h);
      pfAdd(_holes, (void *)new_hole);

      // Reuse best_fit hole.
      best_fit->setOrigin(bf_x, bf_y + height);
      best_fit->setSize(width, bf_h - height);
    }

  }

  *origin_x = bf_x;
  *origin_y = bf_y;

  return TRUE;
}

int qkLightMap::_copyImage(GLubyte *image, GLushort width, 
			   GLushort height, GLushort x, GLushort y)
{
  GLuint *cur;

  for (int j = y; j < height + y; j++) {
    cur = _image + j * _lightmap_size + x;
    GLubyte *cptr = (GLubyte *)cur;
    GLushort tmp;
    // PAUL!!! - added the +10s
    for (int i = 0; i < width; i++) {
      tmp = *image << 1; if (tmp > 255) tmp = 255;
    //tmp = GLushort(255.0f*sqrt(*image/255.0f)) << 1; if (tmp > 255) tmp = 255;
      *(cptr + 0) = tmp; image++;	  // R
      tmp = *image << 1; if (tmp > 255) tmp = 255;
    //tmp = GLushort(255.0f*sqrt(*image/255.0f)) << 1; if (tmp > 255) tmp = 255;
      *(cptr + 1) = tmp; image++;      // G
      tmp = *image << 1; if (tmp > 255) tmp = 255;
    //tmp = GLushort(255.0f*sqrt(*image/255.0f)) << 1; if (tmp > 255) tmp = 255;
      *(cptr + 2) = tmp; image++;	  // B
      *(cptr + 3) = 0xFF;                 // A
      cptr += 4;
    }
  }
  return TRUE;
}

qkLightMapHole *qkLightMap::_findBestFit(GLushort width, GLushort height)
{
  int num_holes = pfGetNum(_holes);
  qkLightMapHole *best_fit = NULL;
  qkLightMapHole *cur_hole = NULL;
  GLushort ch_w, ch_h, bf_w = 0, bf_h = 0;

  for (int i = 0; i < num_holes; i++) {
    cur_hole = (qkLightMapHole *)pfGet(_holes, i);
    cur_hole->getSize(&ch_w, &ch_h);

//     fprintf(stdout, "Hole[%d]: WH: %d,%d  Img: %d,%d\n", i, ch_w, ch_h, 
// 	    width, height);

    // Hole does not fit at all.
    if (ch_w < width || ch_h < height) continue;

    // An exact fit is the best fit!
    if (ch_w == width && ch_h == height) return cur_hole;

    // Compare this hole with previous best fit. Save it if better.
    if (best_fit) {
      if (ch_w < bf_w || ch_h < bf_h) {
	// This is a better fit.
	best_fit = cur_hole;
	bf_w = ch_w;
	bf_h = ch_h;       
      }
    } else {
      best_fit = cur_hole;
      bf_w = ch_w;
      bf_h = ch_h;
    }

  }

  return best_fit;
}

