#ifndef __LIGHT_TEX_H__
#define __LIGHT_TEX_H__

#include "pfbsp_int.h"
#include "qfiles.h"

class qkMemory {
public:
  void* operator new(size_t s) {		      
    return pfMalloc(s, pfGetSharedArena());	      
  }      					      
  void* operator new(size_t s, void *arena) {	      
    return pfMalloc(s, arena);                    
  }						      
  void  operator delete(void *d) {		      
    pfFree(d);			              
  }						      

public:

  qkMemory() {};
  virtual ~qkMemory() {};

};

class qkLightMapHole : public qkMemory {

public:

  qkLightMapHole(GLushort x, GLushort y, GLushort w, GLushort h);
  ~qkLightMapHole();

  void getOrigin(GLushort *x, GLushort *y) { *x = _origin[0]; *y = _origin[1]; };
  void getSize(GLushort *w, GLushort *h) { *w = _size[0]; *h = _size[1]; };

  void setOrigin(GLushort x, GLushort y) { _origin[0] = x; _origin[1] = y; };
  void setSize(GLushort w, GLushort h) { _size[0] = w; _size[1] = h; };

protected:

  GLushort _origin[2];
  GLushort _size[2];

};

class qkLightMap : public qkMemory {

public:

  qkLightMap();
  ~qkLightMap();

  int addMap(GLushort width, GLushort height, GLubyte *image, GLushort *origin_x, GLushort *origin_y);

  pfTexture *getPfTex() { return _tex; };
  pfGeoState *getGState() { return _gst; };

protected:
  
  int _copyImage(GLubyte *image, GLushort width, GLushort height, 
		 GLushort x, GLushort y);
  qkLightMapHole *_findBestFit(GLushort width, GLushort height);

  // PAUL!!
  //const GLushort _lightmap_size = 256;
  static const GLushort _lightmap_size = 256;

  pfGeoState *_gst;
  pfTexture *_tex;
  GLuint *_image;

  pfList *_holes;

  static GLint _count;

};

#endif
