/*
 ============================================================================
    $Revision: 1.0 $        $Date: 1997/11/20 15:01:26 $
 ============================================================================

                      PARADIGM SIMULATION, INCORPORATED
               Copyright (c) 1998 by Paradigm Simulation, Inc.

           This software is licensed and not sold. All use of this
           software is subject to the terms and conditions of the PSI
           software license, which should be read carefully. Copyright
           infringement is a serious and criminal offense.
           For more information, contact Paradigm Simulation at
           1-972-960-2301 or send e-mail to support@paradigmsim.com.

  ============================================================================
*/

// Force use of C API.
#define PF_CPLUSPLUS_API 0

// Uncomment to use post-draw callbacks to render lightmaps.
#define USE_PFGSTATE_CBS

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <ctype.h> // tolower()
#include <time.h>
#include <math.h>
#ifdef WIN32
#include <pf.h>
#include <pfdu.h>
#include <wingdi.h>
#else
#include <Performer/pf.h>
#include <Performer/pfdu.h>
#endif
#include "pfbsp.h"
#include <GL/gl.h>
#include "qfiles.h"
#include "pfbsp_int.h"
#include "entity.h"
#include "scriptlib.h"
#include "lighttex.h"

// PAUL!!
extern float *eyePos;
float playerPlat[2];
float playerStart[4];

// PAUL EXPERIMENT
int dupFaceCount = 0;
int totFaceCount = 0;

//#define __DEBUG__

static pfTexture *loadWal(char *name, texdims_t *dims, GLuint flags);
static void DecompressVis (GLubyte *in, GLubyte *decompressed, quakeBsp *bsp);

//static int unapplyTexLUT(pfTraverser *trav, void *ud);
//static int applyTexLUT(pfTraverser *trav, void *ud);

static int _leafVisPreCull(pfTraverser *trav, void *ud);
static int _findCurLeaf(pfVec3 eye, quakeBsp *bsp);

static int _clusterPostDraw(pfTraverser *trav, void *ud);

static quakeBsp *_loadBsp(const char *fileName);
static void _computeLightMapSize(int face, quakeBsp *bsp);
static pfList *_processFace(int face, pfdGeom *geom, quakeBsp *bsp, 
			    int leaf, pfVec4 color, pfdGeoBuilder *bldr, 
			    pfList **gsets_lm,
			    pfdGeom *geom_lm, pfdGeoBuilder *bldr_lm);
static void  _buildClusterGeode(pfGroup *root, quakeBsp *bsp);
static void  _parentModels(pfGroup *root, quakeBsp *bsp);
static void _optimizeSceneGraph(pfNode *node, quakeBsp *bsp);

//static entity_t *_parseEntity();
//static void _initParser(char *buf);
static void _invokeAllEntityCallbacks(quakeBsp *bsp);
static int _invokeEntityCallbacks(entity_t *ent);
static int _qkFuncPlat(entity_t *entity, void *data);
static int _qkFuncDoor(entity_t *entity, void *data);
static int _qkFuncRotating(entity_t *entity, void *data);
static int _qkFuncPlayerStart(entity_t *entity, void *data);

static int _updatePreApp(pfTraverser *trav, void *data);

#ifdef WIN32
static FILE *_pfdOpenFile(const char *fileName);
#endif


static int gUserDataSlot = -1;
static int gPalettedTex = 0;
static int gRandomColors = 0;
static int gUseLightMaps = 1;
static quakeBsp *gBsp = NULL;

static pfList *gQkEntityFuncList = NULL;

// PAUL!!
static void dot() {
  fprintf(stderr, ".");
  fflush(stderr);
}

#define PRINT_PFVEC2(_level, _vec, _cmt) \
    (pfNotify((_level), PFNFY_PRINT, "%s: (%f, %f)", (_cmt), (_vec)[0], (_vec)[1]))

#define PRINT_PFVEC3(_level, _vec, _cmt) \
    (pfNotify((_level), PFNFY_PRINT, "%s: (%f, %f, %f)", (_cmt), (_vec)[0], (_vec)[1], (_vec)[2]))

#define PRINT_PFVEC4(_level, _vec, _cmt) \
    (pfNotify((_level), PFNFY_PRINT, "%s: (%f, %f, %f, %f)", (_cmt), (_vec)[0], (_vec)[1], (_vec)[2], (_vec)[3]))

typedef GLubyte vec4ub[4];

static vec4ub palette[256] =
{
  { 0,0,0,255 },
  { 15,15,15,255 },
  { 31,31,31,255 },
  { 47,47,47,255 },
  { 63,63,63,255 },
  { 75,75,75,255 },
  { 91,91,91,255 },
  { 107,107,107,255 },
  { 123,123,123,255 },
  { 139,139,139,255 },
  { 155,155,155,255 },
  { 171,171,171,255 },
  { 187,187,187,255 },
  { 203,203,203,255 },
  { 219,219,219,255 },
  { 235,235,235,255 },
  { 99,75,35,255 },
  { 91,67,31,255 },
  { 83,63,31,255 },
  { 79,59,27,255 },
  { 71,55,27,255 },
  { 63,47,23,255 },
  { 59,43,23,255 },
  { 51,39,19,255 },
  { 47,35,19,255 },
  { 43,31,19,255 },
  { 39,27,15,255 },
  { 35,23,15,255 },
  { 27,19,11,255 },
  { 23,15,11,255 },
  { 19,15,7,255 },
  { 15,11,7,255 },
  { 95,95,111,255 },
  { 91,91,103,255 },
  { 91,83,95,255 },
  { 87,79,91,255 },
  { 83,75,83,255 },
  { 79,71,75,255 },
  { 71,63,67,255 },
  { 63,59,59,255 },
  { 59,55,55,255 },
  { 51,47,47,255 },
  { 47,43,43,255 },
  { 39,39,39,255 },
  { 35,35,35,255 },
  { 27,27,27,255 },
  { 23,23,23,255 },
  { 19,19,19,255 },
  { 143,119,83,255 },
  { 123,99,67,255 },
  { 115,91,59,255 },
  { 103,79,47,255 },
  { 207,151,75,255 },
  { 167,123,59,255 },
  { 139,103,47,255 },
  { 111,83,39,255 },
  { 235,159,39,255 },
  { 203,139,35,255 },
  { 175,119,31,255 },
  { 147,99,27,255 },
  { 119,79,23,255 },
  { 91,59,15,255 },
  { 63,39,11,255 },
  { 35,23,7,255 },
  { 167,59,43,255 },
  { 159,47,35,255 },
  { 151,43,27,255 },
  { 139,39,19,255 },
  { 127,31,15,255 },
  { 115,23,11,255 },
  { 103,23,7,255 },
  { 87,19,0,255 },
  { 75,15,0,255 },
  { 67,15,0,255 },
  { 59,15,0,255 },
  { 51,11,0,255 },
  { 43,11,0,255 },
  { 35,11,0,255 },
  { 27,7,0,255 },
  { 19,7,0,255 },
  { 123,95,75,255 },
  { 115,87,67,255 },
  { 107,83,63,255 },
  { 103,79,59,255 },
  { 95,71,55,255 },
  { 87,67,51,255 },
  { 83,63,47,255 },
  { 75,55,43,255 },
  { 67,51,39,255 },
  { 63,47,35,255 },
  { 55,39,27,255 },
  { 47,35,23,255 },
  { 39,27,19,255 },
  { 31,23,15,255 },
  { 23,15,11,255 },
  { 15,11,7,255 },
  { 111,59,23,255 },
  { 95,55,23,255 },
  { 83,47,23,255 },
  { 67,43,23,255 },
  { 55,35,19,255 },
  { 39,27,15,255 },
  { 27,19,11,255 },
  { 15,11,7,255 },
  { 179,91,79,255 },
  { 191,123,111,255 },
  { 203,155,147,255 },
  { 215,187,183,255 },
  { 203,215,223,255 },
  { 179,199,211,255 },
  { 159,183,195,255 },
  { 135,167,183,255 },
  { 115,151,167,255 },
  { 91,135,155,255 },
  { 71,119,139,255 },
  { 47,103,127,255 },
  { 23,83,111,255 },
  { 19,75,103,255 },
  { 15,67,91,255 },
  { 11,63,83,255 },
  { 7,55,75,255 },
  { 7,47,63,255 },
  { 7,39,51,255 },
  { 0,31,43,255 },
  { 0,23,31,255 },
  { 0,15,19,255 },
  { 0,7,11,255 },
  { 0,0,0,255 },
  { 139,87,87,255 },
  { 131,79,79,255 },
  { 123,71,71,255 },
  { 115,67,67,255 },
  { 107,59,59,255 },
  { 99,51,51,255 },
  { 91,47,47,255 },
  { 87,43,43,255 },
  { 75,35,35,255 },
  { 63,31,31,255 },
  { 51,27,27,255 },
  { 43,19,19,255 },
  { 31,15,15,255 },
  { 19,11,11,255 },
  { 11,7,7,255 },
  { 0,0,0,255 },
  { 151,159,123,255 },
  { 143,151,115,255 },
  { 135,139,107,255 },
  { 127,131,99,255 },
  { 119,123,95,255 },
  { 115,115,87,255 },
  { 107,107,79,255 },
  { 99,99,71,255 },
  { 91,91,67,255 },
  { 79,79,59,255 },
  { 67,67,51,255 },
  { 55,55,43,255 },
  { 47,47,35,255 },
  { 35,35,27,255 },
  { 23,23,19,255 },
  { 15,15,11,255 },
  { 159,75,63,255 },
  { 147,67,55,255 },
  { 139,59,47,255 },
  { 127,55,39,255 },
  { 119,47,35,255 },
  { 107,43,27,255 },
  { 99,35,23,255 },
  { 87,31,19,255 },
  { 79,27,15,255 },
  { 67,23,11,255 },
  { 55,19,11,255 },
  { 43,15,7,255 },
  { 31,11,7,255 },
  { 23,7,0,255 },
  { 11,0,0,255 },
  { 0,0,0,255 },
  { 119,123,207,255 },
  { 111,115,195,255 },
  { 103,107,183,255 },
  { 99,99,167,255 },
  { 91,91,155,255 },
  { 83,87,143,255 },
  { 75,79,127,255 },
  { 71,71,115,255 },
  { 63,63,103,255 },
  { 55,55,87,255 },
  { 47,47,75,255 },
  { 39,39,63,255 },
  { 35,31,47,255 },
  { 27,23,35,255 },
  { 19,15,23,255 },
  { 11,7,7,255 },
  { 155,171,123,255 },
  { 143,159,111,255 },
  { 135,151,99,255 },
  { 123,139,87,255 },
  { 115,131,75,255 },
  { 103,119,67,255 },
  { 95,111,59,255 },
  { 87,103,51,255 },
  { 75,91,39,255 },
  { 63,79,27,255 },
  { 55,67,19,255 },
  { 47,59,11,255 },
  { 35,47,7,255 },
  { 27,35,0,255 },
  { 19,23,0,255 },
  { 11,15,0,255 },
  { 0,255,0,255 },
  { 35,231,15,255 },
  { 63,211,27,255 },
  { 83,187,39,255 },
  { 95,167,47,255 },
  { 95,143,51,255 },
  { 95,123,51,255 },
  { 255,255,255,255 },
  { 255,255,211,255 },
  { 255,255,167,255 },
  { 255,255,127,255 },
  { 255,255,83,255 },
  { 255,255,39,255 },
  { 255,235,31,255 },
  { 255,215,23,255 },
  { 255,191,15,255 },
  { 255,171,7,255 },
  { 255,147,0,255 },
  { 239,127,0,255 },
  { 227,107,0,255 },
  { 211,87,0,255 },
  { 199,71,0,255 },
  { 183,59,0,255 },
  { 171,43,0,255 },
  { 155,31,0,255 },
  { 143,23,0,255 },
  { 127,15,0,255 },
  { 115,7,0,255 },
  { 95,0,0,255 },
  { 71,0,0,255 },
  { 47,0,0,255 },
  { 27,0,0,255 },
  { 239,0,0,255 },
  { 55,55,255,255 },
  { 255,0,0,255 },
  { 0,0,255,255 },
  { 43,43,35,255 },
  { 27,27,23,255 },
  { 19,19,15,255 },
  { 235,151,127,255 },
  { 195,115,83,255 },
  { 159,87,51,255 },
  { 123,63,27,255 },
  { 235,211,199,255 },
  { 199,171,155,255 },
  { 167,139,119,255 },
  { 135,107,87,255 },
  { 159,91,83,255 }
};


#ifdef Linux
static void swap2(GLushort *array, GLuint length)
{
}
static void swap4(GLuint *array, GLuint length)
{
}
#else
static void swap2(GLushort *array, GLuint length)
{
  GLushort tmp;
  GLubyte *ptr;
  
  while (length--) {
    tmp = *array;
    *array = ((tmp & 0xff) << 8) | (tmp >> 8);
    array++;
  }
}

static void swap4(GLuint *array, GLuint length)
{
  GLuint tmp;
  while (length--) {
    tmp = *array;
    *array = (tmp << 24) | ((tmp << 8) & (0x00ff0000)) |
      ((tmp >> 8) & 0x0000ff00) | (tmp >> 24);    
    array++;
  }
}
#endif

PF_DLLEXPORT void
pfdInitConverter_bsp(void)
{
  if (gQkEntityFuncList) return;
#ifndef WIN32
  gUserDataSlot = pfGetNamedUserDataSlot("BSP Loader");
#endif
  gQkEntityFuncList = pfNewList(sizeof(void *), 10, pfGetSharedArena());
  fprintf(stderr, "Init bsp\n");
}

PF_DLLEXPORT void    
pfdConverterMode_bsp(int mode, int value)
{
  switch (mode) {
  case PFBSP_PALETTED_TEXTURES:
    gPalettedTex = value;
    break;
  case PFBSP_RANDOM_LEAF_COLORS:
    gRandomColors = value;
    break;
  case PFBSP_USE_LIGHTMAPS:
    gUseLightMaps = value;
    break;

  default:
    pfNotify(PFNFY_WARN, PFNFY_USAGE,
	     "pfdConverterMode_bsp: Unknown mode %d", mode);
  }
}

PF_DLLEXPORT int     
pfdGetConverterMode_bsp(int mode)
{
  switch (mode) {
  case PFBSP_PALETTED_TEXTURES:
    return gPalettedTex;
  case PFBSP_RANDOM_LEAF_COLORS:
    return gRandomColors;
  case PFBSP_USE_LIGHTMAPS:
    return gUseLightMaps;

  default:
    pfNotify(PFNFY_WARN, PFNFY_USAGE,
	     "pfdConverterMode_bsp: Unknown mode %d", mode);
    return -1;
  }
}

PF_DLLEXPORT void    
pfdConverterVal_bsp(int which, float val)
{
  switch (which) {
  default:
    pfNotify(PFNFY_WARN, PFNFY_USAGE,
	     "pfdConverterVal_bsp: Unknown value %d", which);
  }
}


PF_DLLEXPORT float   
pfdGetConverterVal_bsp(int which)
{
  switch (which) {
  default:
    pfNotify(PFNFY_WARN, PFNFY_USAGE,
	     "pfdConverterVal_bsp: Unknown value %d", which);
    return (-1.0f);
  }
}

PF_DLLEXPORT void    
pfdConverterAttr_bsp(int which, void *attr)
{
  switch (which) {
  default:
    pfNotify(PFNFY_WARN, PFNFY_USAGE,
	     "pfdConverterAttr_bsp: Unknown attribute %d", which);
  }
}

PF_DLLEXPORT void *   
pfdGetConverterAttr_bsp(int which)
{
  switch (which) {
  default:
    pfNotify(PFNFY_WARN, PFNFY_USAGE,
	     "pfdConverterAttr_bsp: Unknown attribute %d", which);
    return NULL;
  }
}

static int gammaCorrect(int intensity, float gamma) {
  return (int) (pow((intensity/255.0f), 1.0f/gamma) * 255);
}


PF_DLLEXPORT pfNode *
pfdLoadFile_bsp(const char *fileName, float gamma)
{
  static int firstTime = 1;
  if (firstTime) {
    firstTime = 0;
    for (int j=0; j<255; j++)
      for (int k=0; k<3; k++)
        palette[j][k] = gammaCorrect((int) palette[j][k], gamma);    
  }  

  pfNode *root_node = NULL;
  int i;
  quakeBsp *bsp;

  //fprintf(stderr, "Loading bsp, %s\n", fileName);
  fprintf(stderr, "Loading bsp, %s ", fileName);

  bsp = _loadBsp(fileName);
  fprintf(stderr, " done.\n");
  gBsp = bsp;
  if (bsp == NULL) return NULL;

  /* allocate a new primitive buffer */
  pfdGeom *geom = pfdNewGeom(256);
  pfdGeom *geom_lm = pfdNewGeom(256);

  // Create a pfGroup for each model in bsp.
  // For each model, create sub-groups for each area.
  pfGroup *root = pfNewGroup();
  pfNodeName(root, fileName);

  root_node = (pfNode *)root;
  pfGeode *node;

  pfVec4 model_color;
  pfSetVec4(model_color, 1.0f, 1.0f, 1.0f, 1.0f);
  pfdGeoBuilder *bldr = pfdNewGeoBldr();
  pfdGeoBuilder *bldr_lm = pfdNewGeoBldr();

  if (!gRandomColors) {
    pfCopyVec4(geom->colors[0], model_color);
    pfCopyVec4(geom_lm->colors[0], model_color);
  }
  
  bsp->model_dcs = (pfDCS **)pfMalloc(sizeof(pfDCS *) * bsp->num_models,
		pfGetSharedArena());
  bsp->model_dcs[0] = NULL;
  bsp->modelCluster = (int *) pfMalloc(sizeof(int) * bsp->num_models,
                pfGetSharedArena());
  for (i=0; i<bsp->num_models; i++)
    bsp->modelCluster[i] = -1;

  fprintf(stderr, "Building models ");
  fflush(stderr);

  // Process sub-models first and mark their faces as
  // used so they don't get sucked up into the 
  // main level model.
  for (int j = 1; j < bsp->num_models; j++) {

    dot();

    // Create a named DCS for each model so that the models may be moved.
    bsp->model_dcs[j] = pfNewDCS();

    if (gRandomColors)
      pfuRandomColor(model_color, 0.2f, 0.9f);

    node = pfNewGeode();

    // Grab each face in the model and stuff it into a builder.
    for (i = bsp->models[j].firstface; 
	     i < bsp->models[j].firstface + bsp->models[j].numfaces; i++) {

      assert(i < bsp->num_faces);
      pfList *gsets_lm = NULL; // PAUL!!! - added = NULL
      pfList *gsets = _processFace(i, geom, bsp, -1, model_color, bldr, &gsets_lm, geom_lm, bldr_lm);

      if (gsets) {
	if (pfGetNum(gsets) > 1) 
	  fprintf(stderr, "Face has multiple geosets.\n");
        for (int j = 0; j < pfGetNum(gsets); j++) {
	  pfGeoSet *gs = (pfGeoSet *)pfGet(gsets, j);
	  pfAddGSet(node, gs);
	}
      }
      
      if (gUseLightMaps && gsets_lm) {
#ifdef USE_PFGSTATE_CBS
	for (int j = 0; j < pfGetNum(gsets_lm); j++) {
	  pfGeoSet *gs = (pfGeoSet *)pfGet(gsets_lm, j);
	  pfAddGSet(node, gs);
	}
#else
	pfNodeTravFuncs(node, PFTRAV_DRAW, NULL, _clusterPostDraw);
	pfNodeTravData(node, PFTRAV_DRAW, (void *)gsets_lm);
#endif
      }


    }

    char name[256];
    sprintf(name, "model%03d", i);
    pfNodeName(bsp->model_dcs[j], name);
    pfAddChild(bsp->model_dcs[j], node);

  }
  
  fprintf(stderr, " done.\n");

  pfdDelGeom(geom);
  pfdDelGeoBldr(bldr);
  pfdDelGeom(geom_lm);
  pfdDelGeoBldr(bldr_lm);

  fprintf(stderr, "Building cluster geodes ");
  fflush(stderr);

  // Create pfGeode from the visability clusters.
  _buildClusterGeode(root, bsp);

  fprintf(stderr, " done.\n");

  //printf("dup faces %d\n", dupFaceCount);
  fprintf(stderr, "Clusters %d\n", bsp->num_clusters);
  fprintf(stderr, "Total faces %d\n", totFaceCount);

  // Add custom cull function to do visibility culling and 
  // fov culling.
  // GeoSets passing are added to pfDispList.
  // PAUL!!! - was CULL
  pfNodeTravFuncs(root, PFTRAV_APP, _leafVisPreCull, NULL);
  pfNodeTravData(root, PFTRAV_APP, (void *)bsp);
  //pfNodeTravFuncs(root, PFTRAV_CULL, _leafVisPreCull, NULL);
  //pfNodeTravData(root, PFTRAV_CULL, (void *)bsp);

//  if (gPalettedTex) {
//    pfNodeTravFuncs(root_node, PFTRAV_DRAW, applyTexLUT, unapplyTexLUT);
//    pfNodeTravData(root_node, PFTRAV_DRAW, NULL);
//  }

#if 0
  // Add app callback to update animated textures.
  pfNodeTravFuncs(root, PFTRAV_APP, _updatePreApp, NULL);
  pfNodeTravData(root, PFTRAV_APP, (void *)bsp);
#endif

  // Add entity callbacks to process certain models.
  qkEntityFunc("func_plat", _qkFuncPlat, (void *)bsp);
  qkEntityFunc("func_door", _qkFuncDoor, (void *)bsp);
  qkEntityFunc("func_rotating", _qkFuncRotating, (void *)bsp);
  qkEntityFunc("info_player_start", _qkFuncPlayerStart, (void *)bsp);

  // Callall loader and user installed entity callbacks.
  _invokeAllEntityCallbacks(bsp);

  // Parent moving models according to the cluster they are in.
  // Make sure entity callbacks have been invoked to that models are in proper
  // places.
  _parentModels(root, bsp);

  // _optimizeSceneGraph(root_node, bsp);

  // pfPrint(root_node, PFTRAV_SELF | PFTRAV_DESCEND, PFPRINT_VB_ON, stdout);

  return (pfNode *)root_node;
    
} /* pfdLoadFile_bsp */


PF_DLLEXPORT int
pfdStoreFile_bsp(pfNode *root, const char *fileName)
{
  return 0;
} /* pfdStoreFile_bsp */


static pfTexture *loadWal(char *name, texdims_t *dims, GLuint flags)
{
  FILE *fp;
  miptex_t hdr;
  uint *image;
  char fullName[48];
  int i;
  static pfList *texList = NULL;  
  static int totalTexels = 0;


  if (texList == NULL) 
    texList = pfNewList(sizeof(pfTexture *), 15, pfGetSharedArena());

  // Convert to all lower-case letters.
  int len = strlen(name);
  for (i = 0; i < len; i++) {
    name[i] = tolower(name[i]);
  }

  // Determine if the texture has already been loaded.
  int numTex = pfGetNum(texList);
  for (i = 0; i < numTex; i++) {
    pfTexture *oldtex = (pfTexture *)pfGet(texList, i);
    if (!strcmp(pfGetTexName(oldtex), name)) {
		int w, h;
		pfGetTexImage(oldtex, NULL, NULL, &w, &h, NULL);
		dims->width = w;
		dims->height = h;
		return oldtex;
    }
  }

  strcpy(fullName, name);
  strcat(fullName, ".wal");

#ifdef WIN32
  if ((fp = _pfdOpenFile(fullName)) == NULL)
    return NULL;
#else
  if ((fp = pfdOpenFile(fullName)) == NULL)
    return NULL;
#endif

  fread(&hdr, sizeof(miptex_t), 1, fp);

  swap4((GLuint *)&hdr.width, 6);
  swap4((GLuint *)&hdr.flags, 3);

#ifdef WIN32
// Skip big textures on voodoo.	
  if (hdr.width > 256 || hdr.height > 256) return NULL;
#endif

  dims->width = hdr.width;
  dims->height = hdr.height;

  image = (uint *)pfMalloc(sizeof(GLubyte)*hdr.width*hdr.height, pfGetSharedArena());
  fseek(fp, hdr.offsets[0], SEEK_SET);
  
  fread(image, sizeof(GLubyte), hdr.width*hdr.height, fp);

  totalTexels += (hdr.width*hdr.height + 
    (hdr.width>>1 * hdr.height>>1) + (hdr.width>>2 * hdr.height>>2) +
    (hdr.width>>3 * hdr.height>>3));

  pfTexture *tex = pfNewTex(pfGetSharedArena());
  pfTexName(tex, name);
  
  //  fprintf(stdout, "TotalTex: %d\n", totalTexels);

  if (gPalettedTex) {
    pfTexImage(tex, image, 1, hdr.width, hdr.height, 1);
    pfTexFormat(tex, PFTEX_INTERNAL_FORMAT, GL_LUMINANCE8_EXT );
    pfTexFormat(tex, PFTEX_EXTERNAL_FORMAT, PFTEX_PACK_8);
//    pfTexFormat(tex, PFTEX_IMAGE_FORMAT, PFTEX_LUMINANCE);
//    pfTexFormat(tex, PFTEX_GEN_MIPMAP_FORMAT, PF_OFF);

    pfTexFilter(tex, PFTEX_MINFILTER, PFTEX_POINT);
    pfTexFilter(tex, PFTEX_MAGFILTER, PFTEX_POINT);
    //  tex->setLODRange(0.0, 1.0);

#if 0
    // Load the mip-map levels.
    int w,h;
    uint *limage;
    for (i = 1; i < MIPLEVELS; i++) {
      pfTexture *ltex = pfNewTex(pfGetSharedArena());
      w = hdr.width >> i;
      h = hdr.height >> i;

      limage = (uint *)pfMalloc(sizeof(GLubyte)* w * h, 
				pfGetSharedArena());
      fseek(fp, hdr.offsets[i], SEEK_SET);
      fread(limage, sizeof(GLubyte), w * h, fp);
      pfTexImage(ltex, limage, 1, w, h, 0);
      //     ltex->setFormat(PFTEX_INTERNAL_FORMAT, GL_LUMINANCE8_EXT );
      //     ltex->setFormat(PFTEX_EXTERNAL_FORMAT, PFTEX_PACK_8);
      //     ltex->setFormat(PFTEX_IMAGE_FORMAT, PFTEX_LUMINANCE);
      pfTexLevel(tex, i, ltex);

    }
#endif

#if 0
    if (w != 1) {
      // Save previos level as source for subsequent levels.
      uint *simage = limage;
      int sw = w;
      int sh = h;
      int scale = 2;
      int totalLevels = (int)(logf((float)w) / logf(2.0));
      for (i = totalLevels - MIPLEVELS; i < totalLevels; i++) {

	pfTexture *ltex = pfNewTex(pfGetSharedArena());
	w = hdr.width >> i;
	h = hdr.height >> i;

	limage = (uint *)pfMalloc(sizeof(GLubyte)* w * h, 
				  pfGetSharedArena());
	unsigned char *img = (unsigned char *)limage;
	unsigned char *simg = (unsigned char *)simage;
	scale *= 2;
	// Point sample source image.
	for (int t = 0; t < sw / scale; t++) {
	  for (int s = 0; s < sh / scale; s++) {
	    img[t * w + s] = simg[t * scale * sw + s * scale];
	  }
	}
      
	pfTexImage(ltex, limage, 1, w, h, 0);

	pfTexLevel(tex, i, ltex);
      }
    }
#endif

  } else {
	  
    // Load the level-0 mip-map, convert to rgba and let 
    // pf generate the rest.
      
    GLuint *rgbaimage = (uint *)pfMalloc(sizeof(GLuint)*hdr.width*hdr.height, 
				 pfGetSharedArena());
    GLubyte *img = (GLubyte *)image;
    GLubyte r, g, b, a;

    if (flags & SURF_TRANS33) {
      a = 85;
    } else if (flags & SURF_TRANS66) {
      a = 170;
    } else {
      a = 255;
    }

    // PAUL!! added typecast
    for (i = 0; i < (int) (hdr.width * hdr.height); i++) {
      r = palette[img[i]][0];
      g = palette[img[i]][1];
      b = palette[img[i]][2];
      //      fprintf(stderr, "Index: %d RGB[%d]: %d,%d,%d\n", img[i], i, r, g, b);

     // PAUL!!! 
#ifdef Linux
          rgbaimage[i] = a << 24 | b << 16 | g << 8 | r;
#else
	  rgbaimage[i] = r << 24 | g << 16 | b << 8 | a;
#endif
    }

    pfTexImage(tex, rgbaimage, 4, hdr.width, hdr.height, 0);
    //    pfTexFormat(tex, PFTEX_INTERNAL_FORMAT, GL_RGB5_A1);
    //    pfTexFormat(tex, PFTEX_INTERNAL_FORMAT, PFTEX_RGB5_A1);
    pfTexFormat(tex, PFTEX_EXTERNAL_FORMAT, PFTEX_PACK_8);
    pfTexFormat(tex, PFTEX_IMAGE_FORMAT, PFTEX_RGBA);
    pfTexFilter(tex, PFTEX_MINFILTER, PFTEX_MIPMAP_BILINEAR);
    pfTexFilter(tex, PFTEX_MAGFILTER, PFTEX_BILINEAR);
    
//     pfFree(rgbaimage);
  }


  fclose(fp);

  pfAdd(texList, (void *)tex);

  return tex;
}

#ifdef WIN32
PFNGLCOLORTABLEEXTPROC glColorTableEXT = NULL;
#endif

#if 0
int applyTexLUT(pfTraverser *trav, void *ud)
{
  static int first = 1;
  static GLubyte *table;
  int i;
  int ndx;

  if (first) {
    first = 0;

    table = (GLubyte *)malloc(sizeof(GLubyte) * 4 * 256); /* was 4 * 256 */
    memcpy(table, palette, 4*256);

    // PAUL!!!
//#ifdef WIN32
//    glColorTableEXT = (PFNGLCOLORTABLEEXTPROC)wglGetProcAddress("glColorTableEXT");
//    glColorTableEXT(GL_TEXTURE_2D, GL_RGBA, 256, GL_RGBA,
//		   GL_UNSIGNED_BYTE, (void *)table);
//#else
    /* Create a texture color lookup table. */
//    glColorTableSGI(GL_TEXTURE_COLOR_TABLE_SGI, GL_RGBA,
//		    256, GL_RGBA, GL_UNSIGNED_BYTE, table );
    glColorTable(GL_COLOR_TABLE, GL_RGBA,
		    256, GL_RGBA, GL_UNSIGNED_BYTE, table );
//#endif
  }

#ifdef WIN32

//#else
//  glColorTableSGI(GL_TEXTURE_COLOR_TABLE_SGI, GL_RGBA,
//		  256, GL_RGBA, GL_UNSIGNED_BYTE, table );
  glColorTable(GL_COLOR_TABLE, GL_RGBA,
		  256, GL_RGBA, GL_UNSIGNED_BYTE, table );
  glEnable(GL_COLOR_TABLE);
#endif

  return PFTRAV_CONT;
}

int unapplyTexLUT(pfTraverser *trav, void *ud)
{
#ifdef WIN32
#else
//  glDisable(GL_TEXTURE_COLOR_TABLE_SGI);
#endif
  return PFTRAV_CONT;
}
#endif

static quakeBsp *tmp_bsp = NULL;

static int _compareFaces(const void *elem1, const void *elem2)
{
  int *face1 = (int *)elem1;
  int *face2 = (int *)elem2;

  if (tmp_bsp->lightmaps[*face1].texsize[0] < tmp_bsp->lightmaps[*face2].texsize[0])
    return 1;
  else if (tmp_bsp->lightmaps[*face1].texsize[0] > tmp_bsp->lightmaps[*face2].texsize[0])
    return -1;
  return 0;
}


static quakeBsp *_loadBsp(const char *fileName)
{
  quakeBsp *bsp;
  FILE	*fp	    = NULL;
  dheader_t hdr;
  int i;
  // PAUL!!!
  //FILE *ofp = fopen("bsp_dump.txt", "wa");
  //FILE *ofp = stdout;

#ifdef WIN32
  if ((fp = _pfdOpenFile(fileName)) == NULL)
    return NULL;
#else
  if ((fp = pfdOpenFile(fileName)) == NULL)
    return NULL;
#endif

  //  bsp = new quakeBsp;
  bsp = (quakeBsp *)pfMalloc(sizeof(quakeBsp), pfGetSharedArena());

  fread(&hdr, sizeof(dheader_t), 1, fp);


  // Fixed endianess..
  swap4((GLuint *)&hdr, sizeof(dheader_t)/sizeof(GLuint));

#ifdef __DEBUG__
  // Dump lump info...
  for (i = 0; i < HEADER_LUMPS; i++) {
    fprintf(stdout, "Lump[%d]: Offset: %d  Size: %d\n",
	    i, hdr.lumps[i].fileofs, hdr.lumps[i].filelen);
  }
#endif

  // Read plane list.
  //fprintf(stderr, "reading plane list...");
  //fflush(stderr);
  dot();
  bsp->num_planes = hdr.lumps[LUMP_PLANES].filelen / sizeof(dplane_t);
  bsp->planes = (dplane_t *)pfMalloc(sizeof(dplane_t) * bsp->num_planes,
				     pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_PLANES].fileofs, SEEK_SET);
  fread(bsp->planes, sizeof(dplane_t), bsp->num_planes, fp);
  swap4((GLuint *)bsp->planes, 5*bsp->num_planes);
  //fprintf(stderr, "...%d planes...done.\n", bsp->num_planes);

  // Read model list.
  //fprintf(stderr, "reading models list...");
  //fflush(stderr);
  dot();
  bsp->num_models = hdr.lumps[LUMP_MODELS].filelen / sizeof(dmodel_t);
  bsp->models = (dmodel_t *)pfMalloc(sizeof(dmodel_t) * bsp->num_models,
				     pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_MODELS].fileofs, SEEK_SET);
  fread(bsp->models, sizeof(dmodel_t), bsp->num_models, fp);
  swap4((GLuint *)bsp->models, 12*bsp->num_models);
  //fprintf(stderr, "...%d models...done.\n", bsp->num_models);

#ifdef __DEBUG__
  fprintf(stdout, "Num Models: %d\n", bsp->num_models);
  for (i = 0; i < bsp->num_models; i++) {
    fprintf(stdout, "M[%d]: Head: %d  First: %d  Num: %d\n", i,
	    bsp->models[i].headnode, bsp->models[i].firstface,
	    bsp->models[i].numfaces);
  }
#endif

  // Read vertex list.
  //fprintf(stderr, "reading vertex list...");
  //fflush(stderr);
  dot();
  bsp->num_verts = hdr.lumps[LUMP_VERTEXES].filelen / sizeof(dvertex_t);
  bsp->verts = (pfVec3 *)pfMalloc(sizeof(pfVec3) * bsp->num_verts,
				  pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_VERTEXES].fileofs, SEEK_SET);
  fread(bsp->verts, sizeof(pfVec3), bsp->num_verts, fp);
  swap4((GLuint *)bsp->verts, bsp->num_verts * 3);
  //fprintf(stderr, "...%d verts...done.\n", bsp->num_verts);

#ifdef __DEBUG__
  fprintf(stdout, "Num Verts: %d\n", bsp->num_verts);
  for (i = 0; i < bsp->num_verts; i++) {
    fprintf(stdout, "V[%d]: %f,%f,%f\n", i, bsp->verts[i][0],
	    bsp->verts[i][1], bsp->verts[i][2]);
  }
#endif

  // Read visibility lists.
  //fprintf(stderr, "reading vis lists...");
  //fflush(stderr);
  dot();
  fseek(fp, hdr.lumps[LUMP_VISIBILITY].fileofs, SEEK_SET);
  fread(&bsp->num_clusters, sizeof(GLint), 1, fp);
  swap4((GLuint *)&bsp->num_clusters, 1);

  bsp->cluster_ofs = (offset_t *)pfMalloc(sizeof(offset_t) * bsp->num_clusters,
					  pfGetSharedArena());
  fread(bsp->cluster_ofs, sizeof(offset_t), bsp->num_clusters, fp);
  swap4((GLuint *)bsp->cluster_ofs, bsp->num_clusters*2);

  int len = hdr.lumps[LUMP_VISIBILITY].filelen - sizeof(int) - 
    bsp->num_clusters * sizeof(offset_t);

  bsp->vis_lists = (GLubyte *)pfMalloc(sizeof(GLubyte) * len,
				       pfGetSharedArena());
  fread(bsp->vis_lists, sizeof(GLubyte), len, fp);

  bsp->cluster_leaves = 
    (pfNode **)pfMalloc(sizeof(pfNode *) * bsp->num_clusters, 
			 pfGetSharedArena());
  bsp->cluster_geodes = 
    (pfGeode **)pfMalloc(sizeof(pfGeode *) * bsp->num_clusters, 
			 pfGetSharedArena());
  //fprintf(stderr, "%d clusters...done.\n", bsp->num_clusters);
  #ifdef __DEBUG
  fprintf(stdout, "Num Clusters: %d  Len: %d (Lump: %d)\n", 
	  bsp->num_clusters, len, hdr.lumps[LUMP_VISIBILITY].filelen);
  #endif

  int ofs_correction = sizeof(int) + bsp->num_clusters * sizeof(offset_t);

#ifdef __DEBUG
  GLubyte *decomp = new GLubyte[(bsp->num_clusters+7)>>3];
  GLubyte *comp;

   for (i = 0; i < len; i++) {
     fprintf(stdout, " %x ", bsp->vis_lists[i]);
     if (!(i % 20)) fprintf(stdout, "\n");
   }
   fprintf(stdout, "\n\n");
#endif

  for (i = 0; i < bsp->num_clusters; i++) {
    // Offsets in BSP are relative to begining of VIS lump.  Adjust
    // to be relative to our vis_lists structure.
    bsp->cluster_ofs[i].ofs[0] -= ofs_correction;
    bsp->cluster_ofs[i].ofs[1] -= ofs_correction;

#ifdef __DEBUG
    fprintf(stdout, "Cluster[%d]: Offsets: PVS: %d PHS: %d\n", i,
 	    bsp->cluster_ofs[i].ofs[0], bsp->cluster_ofs[i].ofs[1]);
    comp = &(bsp->vis_lists[bsp->cluster_ofs[i].ofs[0]]);
    DecompressVis(comp, decomp, bsp);
    fprintf(stdout, "Cluster[%d]:\n", i);
    for (int j = 0; j < (bsp->num_clusters+7)>>3; j++) {
      fprintf(stdout, " %x ", decomp[j]);
      if (!(j % 20)) fprintf(stdout, "\n");
    }
    fprintf(stdout, "\n");
#endif
 
    bsp->cluster_leaves[i] = NULL;
    bsp->cluster_geodes[i] = NULL;
  }

  // Read edge list.
  //fprintf(stderr, "reading edge list...");
  //fflush(stderr);
  dot();
  bsp->num_edges = hdr.lumps[LUMP_EDGES].filelen / sizeof(dedge_t);
  bsp->edges = (dedge_t *)pfMalloc(sizeof(dedge_t)*bsp->num_edges,
				    pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_EDGES].fileofs, SEEK_SET);
  fread(bsp->edges, sizeof(dedge_t), bsp->num_edges, fp);
  swap2((GLushort *)bsp->edges, bsp->num_edges*2);
  //fprintf(stderr, "%d edges...done.\n", bsp->num_edges);

#ifdef __DEBUG__
  fprintf(stdout, "Num Edges: %d\n", bsp->num_edges);
  for (i = 0; i < bsp->num_edges; i++) {
    fprintf(stdout, "E[%d]: %d,%d\n", i, bsp->edges[i].v[0],
	    bsp->edges[i].v[1]);
  }
#endif

  // Read surf-edge list.
  //fprintf(stderr, "reading surf-edge list...");
  //fflush(stderr);
  dot();
  bsp->num_sedges = hdr.lumps[LUMP_SURFEDGES].filelen / sizeof(GLint);
  bsp->sedges = (GLint *)pfMalloc(sizeof(GLint)*bsp->num_sedges,
				  pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_SURFEDGES].fileofs, SEEK_SET);
  fread(bsp->sedges, sizeof(GLint), bsp->num_sedges, fp);
  swap4((GLuint *)bsp->sedges, bsp->num_sedges);
  //fprintf(stderr, "%d surf-edges...done.\n", bsp->num_sedges);

#ifdef __DEBUG__
  fprintf(stdout, "Num Surf Edges: %d\n", bsp->num_sedges);
  for (i = 0; i < bsp->num_sedges; i++) {
    fprintf(stdout, "SE[%d]: %d\n", i, bsp->sedges[i]);
  }
#endif

  // Read face list.
  //fprintf(stderr, "reading face list...");
  //fflush(stderr);
  dot();
  bsp->num_faces = hdr.lumps[LUMP_FACES].filelen / sizeof(dface_t);
  bsp->faces = (dface_t *)pfMalloc(sizeof(dface_t)*bsp->num_faces,
				   pfGetSharedArena());
  bsp->lightmaps = (lightmap_t *)pfMalloc(sizeof(lightmap_t)*bsp->num_faces,
					  pfGetSharedArena());
  bsp->used_faces = (int *)pfMalloc(sizeof(int)*bsp->num_faces,
				    pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_FACES].fileofs, SEEK_SET);
  fread(bsp->faces, sizeof(dface_t), bsp->num_faces, fp);
#ifdef __DEBUG__
  fprintf(stderr, "Num Faces: %d\n", bsp->num_faces);
#endif
  //fprintf(stderr, "%d faces...done\n", bsp->num_faces);

  // Fix endianess.
  GLint total_edges = 0;
  for (i = 0; i < bsp->num_faces; i++) {
    swap2((GLushort *)&bsp->faces[i].planenum, 2);
    swap4((GLuint *)&bsp->faces[i].firstedge, 1);
    swap2((GLushort *)&bsp->faces[i].numedges, 2);
    swap4((GLuint *)&bsp->faces[i].lightofs, 1);

    total_edges += bsp->faces[i].numedges;
    bsp->used_faces[i] = GL_FALSE;
  }

#ifdef __DEBUG__
  fprintf(stderr, "Total Edges: %d\n", total_edges);
#endif

  // Read texinfo list.
  //fprintf(stderr, "reading texinfo list...");
  //fflush(stderr);
  dot();
  bsp->num_texinfo = hdr.lumps[LUMP_TEXINFO].filelen / sizeof(texinfo_t);
  bsp->texinfo = (texinfo_t *)pfMalloc(sizeof(texinfo_t)*bsp->num_texinfo,
				       pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_TEXINFO].fileofs, SEEK_SET);
  fread(bsp->texinfo, sizeof(texinfo_t), bsp->num_texinfo, fp);

  bsp->gstates = (pfGeoState **)pfMalloc(sizeof(pfGeoState *) * bsp->num_texinfo, pfGetSharedArena());
  bsp->texmats = (pfMatrix **)pfMalloc(sizeof(pfMatrix *) * bsp->num_texinfo, pfGetSharedArena());
  bsp->texdims = new texdims_t[bsp->num_texinfo];
  //fprintf(stderr, "done.\n");
#ifdef __DEBUG__
  fprintf(stderr, "Num TexInfo: %d\n", bsp->num_texinfo);
#endif

  pfTexEnv *tenv = pfNewTEnv(pfGetSharedArena());
  pfTEnvMode(tenv, GL_REPLACE);

  //fprintf(stderr, "reading textures...");
  //fflush(stderr);
  dot();
  // Fix endianess.
  for (i = 0; i < bsp->num_texinfo; i++) {
    swap4((GLuint *)bsp->texinfo[i].vecs, 10);
    swap4((GLuint *)&bsp->texinfo[i].nexttexinfo, 1);

#ifdef __DEBUG__
    fprintf(stdout, "Tex[%d]: Name: %s Flags: %x Next: %d\n", 
	    i, bsp->texinfo[i].texture,
	    bsp->texinfo[i].flags, bsp->texinfo[i].nexttexinfo);
    fprintf(stdout, "Tex[%d]: S: %f,%f,%f %f  T: %f,%f,%f %f\n", i,
	    bsp->texinfo[i].vecs[0][0], bsp->texinfo[i].vecs[0][1], 
	    bsp->texinfo[i].vecs[0][2], bsp->texinfo[i].vecs[0][3],
	    bsp->texinfo[i].vecs[1][0], bsp->texinfo[i].vecs[1][1], 
	    bsp->texinfo[i].vecs[1][2], bsp->texinfo[i].vecs[1][3]);
#endif

    // Fill in geo-state for this texinfo.
    pfGeoState *tmp = pfNewGState(pfGetSharedArena());
    bsp->gstates[i] = tmp;

    // Read wal texture file.
    pfTexture *tex = loadWal(bsp->texinfo[i].texture, &bsp->texdims[i], 
 			     bsp->texinfo[i].flags);
    pfGStateAttr(bsp->gstates[i], PFSTATE_TEXTURE, (void *)tex);
    pfGStateMode(bsp->gstates[i], PFSTATE_ENTEXTURE, PF_ON);
    pfGStateAttr(bsp->gstates[i], PFSTATE_TEXENV, (void *)tenv);
    pfGStateMode(bsp->gstates[i], PFSTATE_ENLIGHTING, PF_OFF);
    pfGStateMode(bsp->gstates[i], PFSTATE_CULLFACE, PFCF_FRONT);

    // Deal with flowing textures.
    if (bsp->texinfo[i].flags & SURF_FLOWING ) {
      fprintf(stdout, "Found flowing texture  Angle: %d.\n", bsp->texinfo[i].value);
      pfGStateMode(bsp->gstates[i], PFSTATE_ENTEXMAT, PF_ON);
      bsp->texmats[i] = (pfMatrix *)pfMalloc(sizeof(pfMatrix), pfGetSharedArena());
      pfMakeIdentMat(*bsp->texmats[i]);
      pfGStateAttr(bsp->gstates[i], PFSTATE_TEXMAT, bsp->texmats[i]);
    }

    if (bsp->texinfo[i].flags & SURF_TRANS33 ||
	bsp->texinfo[i].flags & SURF_TRANS66) {
      pfGStateMode(bsp->gstates[i], PFSTATE_TRANSPARENCY, PFTR_ON);
    }

  }
  //fprintf(stderr, "done.\n");

  // Read node list.
  dot();
  bsp->num_nodes = hdr.lumps[LUMP_NODES].filelen / sizeof(dnode_t);
#ifdef __DEBUG__
  fprintf(stdout, "Num Nodes: %d\n", bsp->num_nodes);
#endif
  bsp->nodes = (dnode_t *)pfMalloc(sizeof(dnode_t)* bsp->num_nodes,
				   pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_NODES].fileofs, SEEK_SET);
  fread(bsp->nodes, sizeof(dnode_t), bsp->num_nodes, fp);

  // Fix endianess.
  for (i = 0; i < bsp->num_nodes; i++) {
    swap4((GLuint *)&bsp->nodes[i].planenum, 3);
    swap2((GLushort *)bsp->nodes[i].mins, 8);
#ifdef __DEBUG__
    fprintf(stdout, "N[%d]: Plane: %d  Front: %d  Back: %d\n", i,
	    bsp->nodes[i].planenum,
	    bsp->nodes[i].children[0], bsp->nodes[i].children[1]);
    fprintf(stdout, "Plane: ABCD: %f,%f,%f,%f  Type: %d\n",
	    bsp->planes[bsp->nodes[i].planenum].normal[0],
	    bsp->planes[bsp->nodes[i].planenum].normal[1],
	    bsp->planes[bsp->nodes[i].planenum].normal[2],
	    bsp->planes[bsp->nodes[i].planenum].dist,
	    bsp->planes[bsp->nodes[i].planenum].type);

#endif
  }

  // Read leafs
  dot();
  bsp->num_leaves = hdr.lumps[LUMP_LEAFS].filelen / sizeof(dleaf_t);
  bsp->leaves = (dleaf_t *)pfMalloc(sizeof(dleaf_t)*bsp->num_leaves,
				    pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_LEAFS].fileofs, SEEK_SET);
  fread(bsp->leaves, sizeof(dleaf_t), bsp->num_leaves, fp);
  int totalfaces = 0;
  for (i = 0; i < bsp->num_leaves; i++) {
    swap4((GLuint *)&bsp->leaves[i].contents, 1);
    swap2((GLushort *)&bsp->leaves[i].cluster, 12);

#ifdef __DEBUG__
    fprintf(stdout, "L[%d]: FirstFace: %d NumFaces: %d  FirstBrush:%d "
	    "NumBrush: %d Contents: %x Cluster: %d\n", i,
	    bsp->leaves[i].firstleafface, bsp->leaves[i].numleaffaces,
	    bsp->leaves[i].firstleafbrush, bsp->leaves[i].numleafbrushes,
	    bsp->leaves[i].contents, bsp->leaves[i].cluster);
#endif
    totalfaces += bsp->leaves[i].numleaffaces;
  }

  //fprintf(stderr, "Total Leaf Faces: %d\n", totalfaces);

  // Read leaf-faces.
  dot();
  bsp->num_lfaces = hdr.lumps[LUMP_LEAFFACES].filelen / sizeof(GLushort);
  bsp->leaf_faces = (GLushort *)pfMalloc(sizeof(GLushort)*bsp->num_lfaces,
					 pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_LEAFFACES].fileofs, SEEK_SET);
  fread(bsp->leaf_faces, sizeof(GLushort), bsp->num_lfaces, fp);
  swap2((GLushort *)bsp->leaf_faces, bsp->num_lfaces);

  for (i = 0; i < bsp->num_faces; i++) {
    // Compute lightmap size for this face.
    _computeLightMapSize(i, bsp);

#ifdef __DEBUG__
    fprintf(stdout, "F[%d]: First: %d Num: %d", i, bsp->faces[i].firstedge,
	    bsp->faces[i].numedges);
    fprintf(stdout, "  LightSize: %d,%d\n", bsp->lightmaps[i].texsize[0],
	    bsp->lightmaps[i].texsize[1]);
    fprintf(stdout, "  LightStyles: %d, %d, %d, %d   Ofs: %d\n",
	    bsp->faces[i].styles[0], bsp->faces[i].styles[1],
	    bsp->faces[i].styles[2], bsp->faces[i].styles[3],
	    bsp->faces[i].lightofs);
#endif
  }

  if (gUseLightMaps) {

    // Read the lightmaps.
    dot();
    bsp->len_lightmaps = hdr.lumps[LUMP_LIGHTING].filelen;
    bsp->lightdata = (GLubyte *)pfMalloc(sizeof(GLubyte)*bsp->len_lightmaps,
				       pfGetSharedArena());
    fseek(fp, hdr.lumps[LUMP_LIGHTING].fileofs, SEEK_SET);
    fread(bsp->lightdata, sizeof(GLubyte), bsp->len_lightmaps, fp);

    bsp->lighttex = (lighttex_t **)pfMalloc(sizeof(lighttex_t *) * bsp->num_faces,
					    pfGetSharedArena());

    bsp->qklightmaps = pfNewList(sizeof(void *), 3, pfGetSharedArena());

    qkLightMap *cur_lm = new qkLightMap;
    pfAdd(bsp->qklightmaps, (void *)cur_lm);

    int *sorted_faces = (int *)pfMalloc(sizeof(int) * bsp->num_faces,
					pfGetSharedArena());
    for (i = 0; i < bsp->num_faces; i++) 
      sorted_faces[i] = i;

    tmp_bsp = bsp;
    qsort((void *)sorted_faces, bsp->num_faces, sizeof(int), _compareFaces);

    for (i = 0; i < bsp->num_faces; i++) {

      int face = sorted_faces[i];

      // Note: the lightofs of face 0 is now 0.  Rethink this 
      // translation of ofsets.  Perhaps proper offset can be 
      // computed in lightmap class. 
      if (bsp->faces[face].lightofs == 0 && face != 0) {
	bsp->lighttex[face] = NULL;
	continue;
      }

      GLushort lm_w = (GLushort)bsp->lightmaps[face].texsize[0];
      GLushort lm_h = (GLushort)bsp->lightmaps[face].texsize[1];

      GLushort lm_x, lm_y;

      int ok = 0;

      // Start with the first map.
      cur_lm = (qkLightMap *)pfGet(bsp->qklightmaps, 0);

      // Find a place for this lightmap texture.
      while (!ok) {

	ok = cur_lm->addMap(lm_w, lm_h, 
			    &bsp->lightdata[bsp->faces[face].lightofs],
			    &lm_x, &lm_y);
	if (!ok) {
	  int num_maps = pfGetNum(bsp->qklightmaps);
	  int cur_map = pfSearch(bsp->qklightmaps, cur_lm);
	  if (cur_map == num_maps - 1) {
	    cur_lm = new qkLightMap;
	    pfAdd(bsp->qklightmaps, (void *)cur_lm);
	  } else {
	    cur_lm = (qkLightMap *)pfGet(bsp->qklightmaps, cur_map+1);
	  }
	}
      }

      bsp->lighttex[face] = (lighttex_t *)pfMalloc(sizeof(lighttex_t), 
						pfGetSharedArena());
      bsp->lighttex[face]->gst = cur_lm->getGState();
      bsp->lighttex[face]->offset[0] = bsp->faces[face].lightofs;
      bsp->lighttex[face]->origin[0] = lm_x;
      bsp->lighttex[face]->origin[1] = lm_y;
      bsp->lighttex[face]->size[0] = lm_w;
      bsp->lighttex[face]->size[1] = lm_h;
    }

    // PAUL!!!
    // the #ifdef and #endif were commented out
    #ifdef __DEBUG
    for (i = 0; i < pfGetNum(bsp->qklightmaps); i++) {
      qkLightMap *lm = (qkLightMap *)pfGet(bsp->qklightmaps, i);
      pfTexture *lm_tex = lm->getPfTex();
      char name[256];
      sprintf(name, "LM_%d.rgb", i);
      pfSaveTexFile(lm_tex, name);
    }
    #endif

  }

  // Read area list.
  dot();
  bsp->num_areas = hdr.lumps[LUMP_AREAS].filelen / sizeof(darea_t);
  bsp->areas = (darea_t *)pfMalloc(sizeof(darea_t)*bsp->num_areas,
				   pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_AREAS].fileofs, SEEK_SET);
  fread(bsp->areas, sizeof(darea_t), bsp->num_areas, fp);
  swap4((GLuint *)bsp->areas, bsp->num_areas*2);
  // fprintf(stdout, "Num Areas: %d\n", bsp->num_areas);

  // Read portal list.
  dot();
  bsp->num_portals = hdr.lumps[LUMP_AREAPORTALS].filelen / 
    sizeof(dareaportal_t);
  bsp->portals = (dareaportal_t *)pfMalloc(sizeof(dareaportal_t)*bsp->num_portals, pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_AREAPORTALS].fileofs, SEEK_SET);
  fread(bsp->portals, sizeof(dareaportal_t), bsp->num_portals, fp);
  swap4((GLuint *)bsp->portals, bsp->num_portals*2);
  // fprintf(stdout, "Num Portals: %d\n", bsp->num_portals);

  // Read leaf brushes.
  dot();
  bsp->num_lbrushes = hdr.lumps[LUMP_LEAFBRUSHES].filelen / sizeof(GLushort);
  bsp->leaf_brushes = new GLushort[bsp->num_lbrushes];
  fseek(fp, hdr.lumps[LUMP_LEAFBRUSHES].fileofs, SEEK_SET);
  fread(bsp->leaf_brushes, sizeof(GLushort), bsp->num_lbrushes, fp);
  swap2((GLushort *)bsp->leaf_brushes, bsp->num_lbrushes);
  // fprintf(stdout, "Num leaf brushes: %d\n", bsp->num_lbrushes);

  // Read brushes.
  dot();
  bsp->num_brushes = hdr.lumps[LUMP_BRUSHES].filelen / sizeof(dbrush_t);
  bsp->brushes = new dbrush_t[bsp->num_brushes];
  fseek(fp, hdr.lumps[LUMP_BRUSHES].fileofs, SEEK_SET);
  fread(bsp->brushes, sizeof(dbrush_t), bsp->num_brushes, fp);
  swap4((GLuint *)bsp->brushes, bsp->num_brushes*3);
  // fprintf(stdout, "Num brushes: %d\n", bsp->num_brushes);
  
  // Read brush sides
  dot();
  bsp->num_bsides = hdr.lumps[LUMP_BRUSHSIDES].filelen / sizeof(dbrushside_t);
  bsp->bsides = new dbrushside_t[bsp->num_bsides];
  fseek(fp, hdr.lumps[LUMP_BRUSHSIDES].fileofs, SEEK_SET);
  fread(bsp->bsides, sizeof(dbrushside_t), bsp->num_bsides, fp);
  swap2((GLushort *)bsp->bsides, bsp->num_bsides*2);
  // fprintf(stdout, "Num brush sides: %d\n", bsp->num_bsides);

  // Read entity information and invoke entity callbacks.
  dot();
  bsp->len_entities = hdr.lumps[LUMP_ENTITIES].filelen;
  bsp->entity_buf = (char *)pfMalloc(sizeof(char) * bsp->len_entities, 
					pfGetSharedArena());
  fseek(fp, hdr.lumps[LUMP_ENTITIES].fileofs, SEEK_SET);
  fread(bsp->entity_buf, sizeof(char), bsp->len_entities, fp);

  bsp->entities = (entity_t *)pfCalloc(sizeof(entity_t), MAX_MAP_ENTITIES,
					 pfGetSharedArena());

  fclose(fp);

  return bsp;
}


static void _computeLightMapSize(int face, quakeBsp *bsp)
{
  int i, j, e;
  //pfVec2 maxs;
  float val;

  pfSetVec2(bsp->lightmaps[face].mins, 99999.0f, 99999.0f);
  pfSetVec2(bsp->lightmaps[face].maxs, -99999.0f, -99999.0f);

  for (i = 0, e = bsp->faces[face].firstedge; i < bsp->faces[face].numedges;
       i++, e++) {

    // Fill in vertex.
    pfVec3 v;
    GLint edge = bsp->sedges[e];
    if (edge < 0) {
      edge = -edge;
      // Reverse edge.
      pfSetVec3(v, bsp->verts[bsp->edges[edge].v[1]][0],
	    bsp->verts[bsp->edges[edge].v[1]][1], 
	    bsp->verts[bsp->edges[edge].v[1]][2]);
    } else {
      pfSetVec3(v, bsp->verts[bsp->edges[edge].v[0]][0],
	    bsp->verts[bsp->edges[edge].v[0]][1], 
	    bsp->verts[bsp->edges[edge].v[0]][2]);
    }

    int tindx = bsp->faces[face].texinfo;
    pfVec3 tn;

    for (j = 0; j < 2; j++) {

      pfSetVec3(tn, bsp->texinfo[tindx].vecs[j][0], bsp->texinfo[tindx].vecs[j][1], 
	     bsp->texinfo[tindx].vecs[j][2]);
      val = pfDotVec3(tn, v) + bsp->texinfo[tindx].vecs[j][3];

      if (val < bsp->lightmaps[face].mins[j])
	bsp->lightmaps[face].mins[j] = val;
      if (val > bsp->lightmaps[face].maxs[j])
	bsp->lightmaps[face].maxs[j] = val;
    }
  }

  for (i = 0; i < 2; i++) {
    bsp->lightmaps[face].mins[i] = floorf(bsp->lightmaps[face].mins[i]/16.0f);
    bsp->lightmaps[face].maxs[i] = ceilf(bsp->lightmaps[face].maxs[i]/16.0f);
    bsp->lightmaps[face].texsize[i] = (short) (bsp->lightmaps[face].maxs[i] - 
      bsp->lightmaps[face].mins[i]);  // PAUL (added typecast)
  }

  // Add one (because Quake2 does!).
  bsp->lightmaps[face].texsize[0]++;
  bsp->lightmaps[face].texsize[1]++;
}

/***
static int paulPreApply(pfGeoState *gst, void *data)
{
  glBlendFunc(GL_SRC_ALPHA, GL_SRC_ALPHA);
  //glDepthFunc(GL_LESS);
  //glDisable(GL_BLEND);
  return 0;
}

static int paulPostApply(pfGeoState *gst, void *data)
{
  //glEnable(GL_BLEND);
  return 0;
}
****/

static pfList *_processFace(int face, pfdGeom *geom, quakeBsp *bsp, int leaf,
			    pfVec4 color, pfdGeoBuilder *bldr, pfList **lm_gsets,
			    pfdGeom *geom_lm, pfdGeoBuilder *bldr_lm)
{
  // PAUL!!!
  //short tindx = bsp->faces[face].texinfo;

  // Skip faces that are SKY and NODRAW or have already been added
  // to another model.
  /*****
  if (bsp->texinfo[bsp->faces[face].texinfo].flags & SURF_SKY ||
      bsp->texinfo[bsp->faces[face].texinfo].flags & SURF_NODRAW ||
      bsp->used_faces[face] == GL_TRUE) return NULL;

  bsp->used_faces[face] = GL_TRUE;
  *****/

  // PAUL!!!
  // Skip faces that are SKY and NODRAW
  if (bsp->texinfo[bsp->faces[face].texinfo].flags & SURF_SKY ||
      bsp->texinfo[bsp->faces[face].texinfo].flags & SURF_NODRAW)
    return NULL;

  // NOTE: this is it! Find out way of not drawing multiple times!!!
  // IDEA: callback that looks into a table to see if face has already
  //   been drawn.
  totFaceCount++;
  if (bsp->used_faces[face] == GL_TRUE) {
    dupFaceCount++;
    if (gUseLightMaps)
      return NULL;
  }
  bsp->used_faces[face] = GL_TRUE;


  geom->numVerts = bsp->faces[face].numedges;
  geom->primtype = PFGS_POLYS;
  if (gRandomColors)
    geom->cbind = PFGS_PER_VERTEX;
  else
    geom->cbind = PFGS_PER_PRIM;
  geom->nbind = PFGS_OFF;
#if (PF_MAJOR_VERSION == 3) 
  geom->tbind[0] = PFGS_PER_VERTEX;
#else
  geom->tbind = PFGS_PER_VERTEX;
#endif

  geom_lm->numVerts = bsp->faces[face].numedges;
  geom_lm->primtype = PFGS_POLYS;
  if (gRandomColors)
    geom_lm->cbind = PFGS_PER_VERTEX;
  else
    geom_lm->cbind = PFGS_PER_PRIM;
  geom_lm->nbind = PFGS_OFF;
#if (PF_MAJOR_VERSION == 3)
  geom_lm->tbind[0] = PFGS_PER_VERTEX;
#else
  geom_lm->tbind = PFGS_PER_VERTEX;
#endif 

#ifdef __DEBUG
  fprintf(stdout, "Face[%d]: LM Origin: %d,%d Size: %d,%d\n", face,
	  (bsp->lighttex[face] ? bsp->lighttex[face]->origin[0] : 0),
	  (bsp->lighttex[face] ? bsp->lighttex[face]->origin[1] : 0),
	  (bsp->lighttex[face] ? bsp->lighttex[face]->size[0] : 0),
	  (bsp->lighttex[face] ? bsp->lighttex[face]->size[1] : 0));
#endif

  int e, j;
  for (j = 0, e = bsp->faces[face].firstedge; j < bsp->faces[face].numedges; 
       j++, e++) {

    assert(e < bsp->num_sedges);

    // Fill in vertex.
    pfVec3 v;
    GLint edge = bsp->sedges[e];

    assert(edge < bsp->num_edges);

    if (edge < 0) {
      edge = -edge;
      // Reverse edge.
      pfSetVec3(v, bsp->verts[bsp->edges[edge].v[1]][0],
	    bsp->verts[bsp->edges[edge].v[1]][1], 
	    bsp->verts[bsp->edges[edge].v[1]][2]);
    } else {
      pfSetVec3(v, bsp->verts[bsp->edges[edge].v[0]][0],
	    bsp->verts[bsp->edges[edge].v[0]][1], 
	    bsp->verts[bsp->edges[edge].v[0]][2]);
    }
    pfCopyVec3(geom->coords[j], v);
    pfCopyVec3(geom_lm->coords[j], v);

#ifdef __DEBUG
    fprintf(stdout, "V[%d]: %f,%f,%f\n", j, v[0], v[1], v[2]);
#endif

    if (gRandomColors) {
      pfCopyVec4(geom->colors[j], color);
      pfCopyVec4(geom_lm->colors[j], color);
    }

    // Fill in texcoord.
    pfVec3 tn;
    pfVec2 t;
    int tindx = bsp->faces[face].texinfo;
    pfSetVec3(tn, bsp->texinfo[tindx].vecs[0][0], bsp->texinfo[tindx].vecs[0][1], 
		bsp->texinfo[tindx].vecs[0][2]);
    t[0] = pfDotVec3(tn, v) + bsp->texinfo[tindx].vecs[0][3];
    t[0] = t[0] / bsp->texdims[bsp->faces[face].texinfo].width;

#ifdef __DEBUG
    fprintf(stdout, "TGS: %f,%f,%f %f\n", bsp->texinfo[tindx].vecs[0][0], 
	    bsp->texinfo[tindx].vecs[0][1], bsp->texinfo[tindx].vecs[0][2],
	    bsp->texinfo[tindx].vecs[0][3]);
#endif

    pfSetVec3(tn, bsp->texinfo[tindx].vecs[1][0], bsp->texinfo[tindx].vecs[1][1], 
	   bsp->texinfo[tindx].vecs[1][2]);
    t[1] = pfDotVec3(tn, v) + bsp->texinfo[tindx].vecs[1][3];
    t[1] = t[1] / bsp->texdims[bsp->faces[face].texinfo].height;
#if (PF_MAJOR_VERSION == 3)
    pfCopyVec2(geom->texCoords[0][j], t);
#else
    pfCopyVec2(geom->texCoords[j], t);
#endif

    if (gUseLightMaps && bsp->lighttex[face]) {
 
      pfScaleVec3(tn, 1.0f/(256.0f * 16.0f), bsp->texinfo[tindx].vecs[0]); 
      float ofs_s = (bsp->texinfo[tindx].vecs[0][3] / 16.0f - bsp->lightmaps[face].mins[0] +
		     (float)bsp->lighttex[face]->origin[0] + 0.5f) / 256.0f;
      t[0] = pfDotVec3(tn, v) + ofs_s;

      pfScaleVec3(tn, 1.0f/(256.0f * 16.0f), bsp->texinfo[tindx].vecs[1]); 
      float ofs_t = (bsp->texinfo[tindx].vecs[1][3] / 16.0f - bsp->lightmaps[face].mins[1] +
		     (float)bsp->lighttex[face]->origin[1] + 0.5f) / 256.0f;
      t[1] = pfDotVec3(tn, v) + ofs_t;

#if (PF_MAJOR_VERSION == 3)
      pfCopyVec2(geom_lm->texCoords[0][j], t);
#else
      pfCopyVec2(geom_lm->texCoords[j], t);
#endif
    } else {
	    
#if (PF_MAJOR_VERSION == 3)
      pfCopyVec2(geom_lm->texCoords[0][j], t);
#else
      pfCopyVec2(geom_lm->texCoords[j], t);
#endif
    }

#ifdef __DEBUG
    fprintf(stdout, "TGT: %f,%f,%f %f\n", bsp->texinfo[tindx].vecs[1][0], 
	    bsp->texinfo[tindx].vecs[1][1], bsp->texinfo[tindx].vecs[1][2],
	    bsp->texinfo[tindx].vecs[1][3]);
    fprintf(stdout, "T[%d]: %f,%f\n", j, t[0], t[1]);
    fprintf(stdout, "LM T[%d]: %f,%f\n", j, t[0], t[1]);
#endif
	
  }

  pfdAddPoly(bldr, geom);
  const pfList *bldr_gsets = pfdBuildGSets(bldr);

  int num_gsets = pfGetNum(bldr_gsets);
  pfList *gsets = pfNewList(sizeof(pfGeoSet *), num_gsets, pfGetSharedArena());

  // PAUL!!!
  //char *tName = bsp->texinfo[tindx].texture;

  for (int i = 0; i < num_gsets; i++) {
    pfGeoSet *gs = (pfGeoSet *)pfGet(bldr_gsets, i);
    pfAdd(gsets, (void *)gs);
    pfGSetGState(gs, bsp->gstates[bsp->faces[face].texinfo]);

    // contents seemed to be screwed up! - PAUL!!

    // Set isect masks based on texinfo.
/******
    if (bsp->leaves[leaf].contents & CONTENTS_SOLID) {
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_SOLID, PFTRAV_SELF, PF_SET);
      pfGSetIsectMask(gs, 0xFFFF, PFTRAV_SELF, PF_SET);
      fprintf(stderr, "s");
    }
    else if (bsp->leaves[leaf].contents & CONTENTS_WINDOW) {
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_WINDOW, PFTRAV_SELF, PF_SET);
      pfGSetIsectMask(gs, 0xFFFF, PFTRAV_SELF, PF_SET);
      fprintf(stderr, "W");
    } 
    else if (bsp->leaves[leaf].contents & CONTENTS_AUX) {
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_WINDOW, PFTRAV_SELF, PF_SET);
      pfGSetIsectMask(gs, 0xFFFF, PFTRAV_SELF, PF_SET);
      fprintf(stderr, "a");
    }
    else if (bsp->leaves[leaf].contents & CONTENTS_LAVA) {
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_LAVA, PFTRAV_SELF, PF_SET);
      pfGSetIsectMask(gs, 0xFFFF, PFTRAV_SELF, PF_SET);
      fprintf(stderr, "l");
    }
    else if (bsp->leaves[leaf].contents & CONTENTS_SLIME) {
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_SLIME, PFTRAV_SELF, PF_SET);
      pfGSetIsectMask(gs, 0xFFFF, PFTRAV_SELF, PF_SET);
      fprintf(stderr, "S");
    }
    else if (bsp->leaves[leaf].contents & CONTENTS_WATER) {
      fprintf(stderr, "w");
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_WATER, PFTRAV_SELF, PF_SET);
      pfGSetIsectMask(gs, 0x0, PFTRAV_SELF, PF_SET);
    }
    else if (bsp->leaves[leaf].contents & CONTENTS_MIST) {
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_MIST, PFTRAV_SELF, PF_SET);
      pfGSetIsectMask(gs, 0x0, PFTRAV_SELF, PF_SET);
      fprintf(stderr, "m");
    }
    else {
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_WATER, PFTRAV_SELF, PF_SET);
      //pfGSetIsectMask(gs, 0x0, PFTRAV_SELF, PF_SET);
      //pfGSetIsectMask(gs, PFBSP_ISECT_MASK_SOLID, PFTRAV_SELF, PF_SET);
      pfGSetIsectMask(gs, 0xFFFF, PFTRAV_SELF, PF_SET);
      fprintf(stderr, ".");
    }
******/
    // PAUL!!
    // see below... lm gsets will determine isect
    if (gUseLightMaps)
      pfGSetIsectMask(gs, 0x0, PFTRAV_SELF, PF_SET);
    else
      pfGSetIsectMask(gs, 0xFFFF, PFTRAV_SELF, PF_SET);
    

  }

  pfList *gsets_lm = NULL;

  if (gUseLightMaps && bsp->lighttex[face]) {

  // PAUL!!
  //char *tName = bsp->texinfo[tindx].texture;
  //fprintf(stderr, ":%s ", tName);
  //  else if (bsp->leaves[leaf].contents & CONTENTS_WATER)
  //if (gUseLightMaps && bsp->lighttex[face] && (bsp->leaves[leaf].contents == 0)) {

    pfdAddPoly(bldr_lm, geom_lm);
    bldr_gsets = (pfList *)pfdBuildGSets(bldr_lm);

    num_gsets = pfGetNum(bldr_gsets);
    gsets_lm = pfNewList(sizeof(pfGeoSet *), num_gsets, pfGetSharedArena());

    for (int i = 0; i < num_gsets; i++) {
      pfGeoSet *gs = (pfGeoSet *)pfGet(bldr_gsets, i);
      pfAdd(gsets_lm, (void *)gs);
      // PAUL!! - things that have light map will stop you
      pfGSetIsectMask(gs, 0xFFFF, PFTRAV_SELF, PF_SET);
      //pfGSetIsectMask(gs, 0x0, PFTRAV_SELF, PF_SET);
      pfGSetGState(gs, bsp->lighttex[face]->gst);
      // PAUL!! - lightmaps drawn last
#ifdef Linux
      pfGSetDrawBin(gs, PFSORT_TRANSP_BIN);
#else
      pfGSetDrawBin(gs, 2);
#endif
    }
  }
  // PAUL!!!
  //else
  //  fprintf(stderr, "%s\n", tName);

  *lm_gsets = gsets_lm;
  return gsets;
}


//
// Entity callback structures.
//
// Store a single callback for each classname.
//

struct _qkEntityFunc 
{
  PFSTRUCT_DECLARE

  int iclassname;
  char *classname;
  qkEntityCb *func;
  void *data;
};

unsigned int _qkHashStr(const char *str)
{
  unsigned int hash = 0;
  unsigned int wrap = 0;

  while( *str != '\0' ) {
    
    hash = (hash << 4) + *str;
    wrap =  hash & 0xf0000000;
    if (wrap != 0)
      hash ^= wrap >> 24;

    ++str;
  }
  return hash;
}

PF_DLLEXPORT int qkEntityFunc(const char *classname, qkEntityCb *func, void *data)
{

  // Search the func list for given classname.
  int id = _qkHashStr(classname);

  // If found replace function with new func.
  int num_funcs = pfGetNum(gQkEntityFuncList);
  for (int i = 0; i < num_funcs; i++) {
    _qkEntityFunc *ent = (_qkEntityFunc *)pfGet(gQkEntityFuncList, i);
    if (id == ent->iclassname && !strcmp(classname, ent->classname)) {
      // Got a match
      ent->func = func;
      ent->data = data;
      return 1;
    } 
  }

  // Else append a new entry to the list.
  _qkEntityFunc *ent = new _qkEntityFunc;
  ent->iclassname = id;
  ent->classname = (char *)pfMalloc(sizeof(char)*(strlen(classname)+1),
		pfGetSharedArena());
  strcpy(ent->classname, classname);
  ent->func = func;
  ent->data = data;

  pfAdd(gQkEntityFuncList, (void *)ent);

  return 0;
}

static int _invokeEntityCallbacks(entity_t *ent)
{
  _qkEntityFunc *func;

  // PAUL!!!
  //PrintEntity(ent);

  // Find entity's classname.
  epair_t *ce = ent->epairs;
  while (ce) {

    if (!strcmp("classname", ce->key)) {

      // PAUL!!! 
      //unsigned int ival = _qkHashStr(ce->value);
      int ival = _qkHashStr(ce->value);
      
      int num = pfGetNum(gQkEntityFuncList);
      for (int i = 0; i < num; i++) {
	    func = (_qkEntityFunc *)pfGet(gQkEntityFuncList,i);
	    if (ival == func->iclassname && !strcmp(ce->value, func->classname)) {
	      // Invoke callback.
	      (func->func)(ent, func->data);
		}
      }
      ce = ce->next;

    } else {
      ce = ce->next;
    }

  }

  return 0;
}


#ifdef WIN32
static FILE *_pfdOpenFile(const char *fileName)
{
  char fullPath[PF_MAXSTRING];
  FILE *fp;

  if (pfFindFile(fileName, fullPath, R_OK | F_OK)) {
    fp = fopen(fullPath, "rb");
    return fp;
  }
  return NULL;
}
#endif

// PAUL!!! - returns 0 is not visible, 1 if visible, or -1 if negative cluster
PF_DLLEXPORT int qkFindCurCluster(float *eyeP, qkBsp *bsp) {
  pfVec3 eye;
  int leaf, cluster;
  unsigned int dm;
  quakeBsp *qbsp;

  eye[0] = eyeP[0];
  eye[1] = eyeP[1];
  eye[2] = eyeP[2];

  qbsp = (quakeBsp *) bsp;
  leaf = _findCurLeaf(eye, qbsp);

  assert(leaf < qbsp->num_leaves);
  assert(leaf > 0);

  cluster = qbsp->leaves[leaf].cluster;
  if (cluster < 0)
    return -1;
  dm = pfGetNodeTravMask(qbsp->cluster_leaves[cluster], PFTRAV_DRAW);
 
  if (dm == 0)
    return 0;
  else
    return 1;
}

static int _leafVisPreCull(pfTraverser *trav, void *ud)
{
  quakeBsp *bsp = (quakeBsp *)ud;
  //pfNode *node = pfGetTravNode(trav);
  //pfChannel *chan = pfGetTravChan(trav);
  pfVec3 eye;
  static int last_cluster = -2;

  //  fprintf(stderr, "_leafVisPreCull\n");

  // Find current leaf node in bsp.
/***
#ifdef WIN32
  pfVec3 hpr;
  pfGetChanView(chan, eye, hpr);
#else
  pfGetChanEye(chan, eye);
#endif
****/

// PAUL!!!
// OK, EYE is the POSITION of the viewpoint. Dir not needed
  eye[0] = eyePos[0];
  eye[1] = eyePos[1];
  eye[2] = eyePos[2];

//  fprintf(stderr, "eye: %f %f %f\n", eye[0], eye[1], eye[2]);

  int leaf = _findCurLeaf(eye, bsp);

  assert(leaf < bsp->num_leaves);
  assert(leaf > 0);

  int cluster = bsp->leaves[leaf].cluster;

  //fprintf(stderr, "Cur Cluster: %d  Last: %d\n", cluster, last_cluster);

  if (cluster == last_cluster) {
     pfCullResult(PFIS_TRUE);
     return PFTRAV_CONT;
   }

  last_cluster = cluster;

  if (cluster < 0) {
    fprintf(stderr, "Negative cluster!\n");
    pfCullResult(PFIS_TRUE);
    for (int i = 0; i < bsp->num_clusters; i++) {
      // draw same as before, but no isect
      //if (bsp->cluster_leaves[i]) pfNodeTravMask(bsp->cluster_leaves[i], PFTRAV_DRAW, 
//						 0xFFFFFFFF, PFTRAV_SELF, PF_SET);
      // PAUL!! - if outside, no isect
      if (bsp->cluster_leaves[i]) pfNodeTravMask(bsp->cluster_leaves[i], PFTRAV_ISECT, 0x0, PFTRAV_SELF, PF_SET);
    }
    return PFTRAV_CONT;
  }

  int offset = bsp->cluster_ofs[cluster].ofs[0];
  GLubyte *pv = &(bsp->vis_lists[offset]);
  GLubyte  v = bsp->vis_lists[offset];

  int i;
  for (i = 0 ; i < bsp->num_clusters; i++) {
    if (bsp->cluster_leaves[i]) {
	  pfNodeTravMask(bsp->cluster_leaves[i], PFTRAV_DRAW, 0x0, PFTRAV_SELF, PF_SET);
          // PAUL!!
      pfNodeTravMask(bsp->cluster_leaves[i], PFTRAV_ISECT, 0x0, PFTRAV_SELF, PF_SET);	
    }
  }

  // Traverse this pfGeode's pfGeoSets...
  // Cull based on cluster's visibility list and then to the pfChannel.
  int count = 0;
  for (i = 0; i < bsp->num_clusters; ){
    if (v == 0) {
      //fprintf(stderr, "#");
      //v = *(pv+1); pv++; // PAUL note: run-length encoding...
      pv++; v = *pv;
      i += (v * 8);
    } else {
/*** wrong direction!
      for (GLubyte bit = 0x80; bit > 0; bit = bit / 2, i++) {
        if (v & bit) {
          if (bsp->cluster_leaves[i]) {
	    pfNodeTravMask(bsp->cluster_leaves[i], PFTRAV_DRAW, 0xFFFFFFFF, 
			   PFTRAV_SELF, PF_SET);
	    pfNodeTravMask(bsp->cluster_leaves[i], PFTRAV_ISECT, 0xFFFF, 
			   PFTRAV_SELF, PF_SET);
          }
        }
      }
    }
****/
      int j = 8;
      while (j--) {
	if (v & 0x01) {
          count++;
	  // Cluster is visible, set draw mask to draw geode.
	  //assert(i < bsp->num_clusters);
          // PAUL!! first condition already met by for loop
          //if (i < bsp->num_clusters && bsp->cluster_leaves[i]) {
          if (bsp->cluster_leaves[i]) {
            //fprintf(stderr, "%d ", i);
	    pfNodeTravMask(bsp->cluster_leaves[i], PFTRAV_DRAW, 0xFFFFFFFF, 
			   PFTRAV_SELF, PF_SET);
	    //PAUL!!
	    pfNodeTravMask(bsp->cluster_leaves[i], PFTRAV_ISECT, 0xFFFF, 
			   PFTRAV_SELF, PF_SET);
          }
         
	}
	i++;
	v = v >> 1;
      }
    }
    pv++;
    v = *pv;
  }
  //fprintf(stderr,"%d: %d of %d clusters visible\n", cluster, count, bsp->num_clusters);

  pfCullResult(PFIS_TRUE);

  return PFTRAV_CONT;
}

static int _findCurLeaf(pfVec3 eye, quakeBsp *bsp)
{
  int leaf = 0;
  int found = 0;

  int node = bsp->models[0].headnode;
  int next_node;
  float dist;

  while (!found) {

    int plane_num = bsp->nodes[node].planenum;

    dist = pfDotVec3(bsp->planes[plane_num].normal, eye);
    if (dist > bsp->planes[plane_num].dist) {
      next_node = bsp->nodes[node].children[0];
    } else {
      next_node = bsp->nodes[node].children[1];
    }
    if (next_node >= 0) {
      node = next_node;
    } else {
      //leaf = ~next_node;
      // PAUL: same thing
      leaf = -(next_node + 1);
      found = 1;
    }
  }

  return leaf;
}

static void  _buildClusterGeode(pfGroup *root, quakeBsp *bsp)
{
  pfdGeoBuilder *bldr = pfdNewGeoBldr();
  pfdGeoBuilder *bldr_lm = pfdNewGeoBldr();
  pfdGeom *geom = pfdNewGeom(256);
  pfdGeom *geom_lm = pfdNewGeom(256);
  //pfGeode *cluster_geode = NULL;

  pfVec4 leaf_color;
  pfSetVec4(leaf_color, 1.0f, 1.0f, 1.0f, 1.0f);

  if (!gRandomColors) {
    pfCopyVec4(geom->colors[0], leaf_color);
    pfCopyVec4(geom_lm->colors[0], leaf_color);
  }

  // PAUL
  int perDot = bsp->num_leaves/40;

  // Add each leaf in this area to the pfdBuilder.
  int k, i;
  for (k = 0; k < bsp->num_leaves; k++) {
    //printf("%d ", bsp->leaves[k].cluster);

    if (k%perDot == 0)
      dot();

    int firstface = bsp->leaves[k].firstleafface;
    int numfaces = bsp->leaves[k].numleaffaces;
    int cluster = bsp->leaves[k].cluster;
    //int valid_face = 0;
    if (gRandomColors)
      pfuRandomColor(leaf_color, 0.2f, 0.9f);

    for (i = firstface; i < firstface + numfaces; i++) {

      int cf = bsp->leaf_faces[i];

      assert(cf < bsp->num_faces);
      
      pfList *gsets_lm = NULL;
      pfList *gsets = _processFace(cf, geom, bsp, k, leaf_color, bldr, &gsets_lm, geom_lm, bldr_lm);

      if (gsets) {
	assert(bsp->leaves[k].cluster < bsp->num_clusters);

	if (!bsp->cluster_leaves[cluster]) {
	  bsp->cluster_leaves[cluster] = (pfNode *)pfNewGroup();
	  bsp->cluster_geodes[cluster] = pfNewGeode();
	  pfAddChild(bsp->cluster_leaves[cluster],
                     bsp->cluster_geodes[cluster]);
	  pfAddChild(root, bsp->cluster_leaves[cluster]);
/****
	  pfNodeTravMask(bsp->cluster_leaves[bsp->leaves[k].cluster], 
          		 PFTRAV_DRAW, 0x0, PFTRAV_SELF, PF_SET);
          // PAUL!!!
	  pfNodeTravMask(bsp->cluster_leaves[bsp->leaves[k].cluster], 
			 PFTRAV_ISECT, 0x0, PFTRAV_SELF, PF_SET);
*****/
	// PAUL!!!!  was 0x0
	  pfNodeTravMask(bsp->cluster_leaves[cluster], 
          		 PFTRAV_DRAW, 0xFFFFFFFF, PFTRAV_SELF, PF_SET);
          // PAUL!!!
	  pfNodeTravMask(bsp->cluster_leaves[cluster], 
			 PFTRAV_ISECT, 0x0, PFTRAV_SELF, PF_SET);
	}

	for (int j = 0; j < pfGetNum(gsets); j++) {
	  pfGeoSet *gs = (pfGeoSet *)pfGet(gsets, j);
	  assert(bsp->cluster_geodes[cluster]);
	  pfAddGSet(bsp->cluster_geodes[cluster], gs);
	}
      }

      if (gUseLightMaps && gsets_lm) {
#ifdef USE_PFGSTATE_CBS
	for (int j = 0; j < pfGetNum(gsets_lm); j++) {
	  pfGeoSet *gs = (pfGeoSet *)pfGet(gsets_lm, j);
	  assert(bsp->cluster_geodes[cluster]);
	  pfAddGSet(bsp->cluster_geodes[cluster], gs);
	}
#else
	fprintf(stderr, "Adding cluster post draw.\n");
	pfNodeTravFuncs(bsp->cluster_leaves[cluster], 
		       PFTRAV_DRAW, NULL, _clusterPostDraw);
	pfNodeTravData(bsp->cluster_leaves[cluster], 
		       PFTRAV_DRAW, (void *)gsets_lm);
#endif
      }

    }
  }

  pfdDelGeom(geom);
  pfdDelGeoBldr(bldr);
  pfdDelGeom(geom_lm);
  pfdDelGeoBldr(bldr_lm);

}

/*
===================
DecompressVis
===================
*/
static void DecompressVis (GLubyte *in, GLubyte *decompressed, quakeBsp *bsp)
{
  int		c;
  GLubyte	*out;
  int		row;

  row = (bsp->num_clusters+7)>>3;	
  out = decompressed;

  do {

    if (*in) {
      *out = *in;
	  out++; in++;
      continue;
    }
	
    c = in[1];
    if (!c)
      fprintf(stderr, "DecompressVis: 0 repeat\n");
    in += 2;
    while (c) {
      *out = 0; out++;
      c--;
    }
  } while (out - decompressed < row);
}


static int _qkRotateCb(pfTraverser *trav, void *data)
{
  float *rotInfo = (float *) data;
  pfDCS *dcs = (pfDCS *)pfGetTravNode(trav);
  
  float newTime = pfGetTime();
  float elapsedTime = newTime - rotInfo[2];
  rotInfo[1] = rotInfo[1] + rotInfo[0] * elapsedTime;
  rotInfo[2] = newTime;
  if (rotInfo[3] != 7)
    pfDCSRot(dcs, rotInfo[1], 0.0f, 0.0f);
  else
    pfDCSRot(dcs, 0.0f, rotInfo[1], 0.0f);

  return PFTRAV_CONT;
}

static int _qkPlatCb(pfTraverser *trav, void *data) {
  float *platInfo = (float *) data;
  pfDCS *dcs = (pfDCS *) pfGetTravNode(trav);

  float newTime = pfGetTime();
  float elapsedTime = newTime - platInfo[2];
  platInfo[1] = platInfo[1] + platInfo[4] * platInfo[0] * elapsedTime;
  if (platInfo[1] > 0.0f) // plats start at top
    platInfo[1] = 0.0f;
  if (platInfo[1] < -platInfo[3])
    platInfo[1] = -platInfo[3];

  float xDist = fabsf(eyePos[0] - platInfo[5]);
  float yDist = fabsf(eyePos[1] - platInfo[6]);

  if (xDist < 50.0f && yDist < 50.0f) {
    platInfo[4] = 1; // up
    playerPlat[0] = 1;
    playerPlat[1] = platInfo[1];
  }
  else
    platInfo[4] = -1; // down

  platInfo[2] = newTime;
  pfDCSTrans(dcs, 0.0, 0.0, platInfo[1]);

  return PFTRAV_CONT;
}

static int _qkDoorCb(pfTraverser *trav, void *data) {
  float *doorInfo = (float *) data;
  pfDCS *dcs = (pfDCS *) pfGetTravNode(trav);

  float newTime = pfGetTime();
  float elapsedTime = newTime - doorInfo[2];
  doorInfo[1] = doorInfo[1] + doorInfo[7] * doorInfo[0] * elapsedTime;

  if (doorInfo[1] > doorInfo[3])
    doorInfo[1] = doorInfo[3];
  if (doorInfo[1] < 0.0)
    doorInfo[1] = 0.0;

  float xDist = fabsf(eyePos[0] - doorInfo[8]);
  float yDist = fabsf(eyePos[1] - doorInfo[9]);
  //fprintf(stderr, "xDist: %f yDis: %f\n", xDist, yDist);

  if (xDist < 90.0f && yDist < 90.0f)
    doorInfo[7] = 1;  // open
  else
    doorInfo[7] = -1; // close

  doorInfo[2] = newTime;
  if (doorInfo[4] == -1.0f)
    pfDCSTrans(dcs, 0.0, 0.0, doorInfo[1]);
  else if (doorInfo[4] == -2.0f)
    pfDCSTrans(dcs, 0.0, 0.0, -doorInfo[1]);
  else
    pfDCSTrans(dcs, doorInfo[1]*doorInfo[5], doorInfo[1]*doorInfo[6], 0.0f); 

  return PFTRAV_CONT;
}

static int _qkFuncPlayerStart(entity_t *entity, void *data) {

  epair_t *ep = entity->epairs;
  int start = 1;
  float startPos[3], startH;

  for (ep = entity->epairs; ep; ep = ep->next) {
    if (!strcmp("origin", ep->key)) 
      sscanf(ep->value, "%f %f %f", &startPos[0], &startPos[1], &startPos[2]);
    else if (!strcmp("angle", ep->key))
      sscanf(ep->value, "%f", &startH);
    else if (!strcmp("targetname", ep->key))
      start = 0;
  }

  if (start) {
    playerStart[0] = startPos[0];
    playerStart[1] = startPos[1];
    playerStart[2] = startPos[2];
    playerStart[3] = startH-90.0f;
    printf("Found info_player_start: ");
    printf("%f %f %f H: %f\n", playerStart[0], playerStart[1], playerStart[2], playerStart[3]);
  }
  return 0;
}

static int _qkFuncPlat(entity_t *entity, void *data) {
  quakeBsp *bsp = (quakeBsp *)data;

  fprintf(stderr, "Got platform model. \n");
  epair_t *ep = entity->epairs;

  int model_num = -1;
  int speed=0, lip=5, height=0;
  char aster;

  for (ep = entity->epairs ; ep ; ep = ep->next) {
    if (!strcmp("model", ep->key)) {
      sscanf(ep->value, "%c%d", &aster, &model_num);
    } else if (!strcmp("speed", ep->key)) {
      sscanf(ep->value, "%d", &speed);
    } else if (!strcmp("lip", ep->key)) {
      sscanf(ep->value, "%d", &lip);
    } else if (!strcmp("height", ep->key)) {
      sscanf(ep->value, "%d", &height);
    }
  }

  // Verify we have a valid model
  if (model_num > 0 && model_num < bsp->num_models) {
    //if (speed != 0) {
      if (speed == 0) speed = 50;
      //fprintf(stderr, "speed: %d\n", speed);
      float *mins = (bsp->models[model_num]).mins;
      float *maxs = (bsp->models[model_num]).maxs;
      /****
      fprintf(stderr, "mins: %f %f %f  maxs: %f %f %f\n",
                     mins[0], mins[1], mins[2],
                     maxs[0], maxs[1], maxs[2]);
      *****/
      // was PFTRAV_CULL
      pfNodeTravFuncs(bsp->model_dcs[model_num], PFTRAV_APP, NULL,
		      _qkPlatCb);
      //pfSphere sph;
      //pfGetNodeBSphere(bsp->model_dcs[model_num], &sph);

      // too lazy to make a struct... :)
      float *platInfo = (float *) pfMalloc(sizeof(float)*7, pfGetSharedArena());
      platInfo[0] = speed;
      platInfo[1] = 0.0f;
      platInfo[2] = pfGetTime();
      //platInfo[3] = maxs[2] - mins[2]; //sph.radius*2;
      platInfo[3] = maxs[2] - mins[2] - lip;
      if (height > 0)
        platInfo[3] = height - lip;
      platInfo[4] = 1; // direction
      platInfo[5] = (maxs[0] + mins[0])/2.0f;
      platInfo[6] = (maxs[1] + mins[1])/2.0f;
      // was PFTRAV_CULL
      pfNodeTravData(bsp->model_dcs[model_num], PFTRAV_APP, platInfo);
    //}
  }

  return 0;
}

static int _qkFuncDoor(entity_t *entity, void *data) {
  quakeBsp *bsp = (quakeBsp *)data;

  fprintf(stderr, "Got door model. \n");
  epair_t *ep = entity->epairs;

  int model_num = -1;
  pfVec3 pos;
  int angle=0, speed=0;
  char aster;

  pfSetVec3(pos, 0.0f, 0.0f, 0.0f);
  for (ep = entity->epairs ; ep ; ep = ep->next) {
    if (!strcmp("origin", ep->key)) {
      sscanf(ep->value, "%f %f %f", &pos[0], &pos[1], &pos[2]);
    } else if (!strcmp("model", ep->key)) {
      sscanf(ep->value, "%c%d", &aster, &model_num);
    } else if (!strcmp("angle", ep->key)) {
      sscanf(ep->value, "%d", &angle);
    } else if (!strcmp("speed", ep->key)) {
      sscanf(ep->value, "%d", &speed);
    }
  }

  // Verify we have a valid model
  if (model_num > 0 && model_num < bsp->num_models) {
    pfDCSTrans(bsp->model_dcs[model_num], pos[0], pos[1], pos[2]);
    //if (speed != 0) {
      if (speed == 0) speed = 50; 
      //fprintf(stderr, "speed: %d\n", speed);
      float *mins = (bsp->models[model_num]).mins;
      float *maxs = (bsp->models[model_num]).maxs;
      /***
      fprintf(stderr, "mins: %f %f %f  maxs: %f %f %f\n",
                     mins[0], mins[1], mins[2],
                     maxs[0], maxs[1], maxs[2]);
      ****/
      // was PFTRAV_CULL
      pfNodeTravFuncs(bsp->model_dcs[model_num], PFTRAV_APP, NULL,
		      _qkDoorCb);
      //pfSphere sph;
      //pfGetNodeBSphere(bsp->model_dcs[model_num], &sph);

      // too lazy to make a struct... :)
      float *doorInfo = (float *) pfMalloc(sizeof(float)*10, pfGetSharedArena());
      doorInfo[0] = speed;
      doorInfo[1] = 0;
      doorInfo[2] = pfGetTime();
      doorInfo[3] = maxs[2] - mins[2]; //sph.radius*2;
      doorInfo[4] = angle;
      doorInfo[5] = cos(angle*3.14/180.0f);
      doorInfo[6] = sin(angle*3.14/180.0f);
      doorInfo[7] = 1; // direction
      doorInfo[8] = (maxs[0] + mins[0])/2.0f; //pos[0];
      doorInfo[9] = (maxs[1] + mins[1])/2.0f; //pos[1];
      // was PFTRAV_CULL
      pfNodeTravData(bsp->model_dcs[model_num], PFTRAV_APP, doorInfo);
    //}
  }

  return 0;
}


static int _qkFuncRotating(entity_t *entity, void *data)
{
  quakeBsp *bsp = (quakeBsp *)data;

  fprintf(stderr, "Got rotating model.\n");
  epair_t *ep = entity->epairs;

  int model_num = -1;
  pfVec3 pos;
  int angle = 0, speed = 0;
  char aster;
  int spawnflags;

  pfSetVec3(pos, 0.0f, 0.0f, 0.0f);
  for (ep = entity->epairs ; ep ; ep = ep->next) {
    if (!strcmp("origin", ep->key)) {
      sscanf(ep->value, "%f %f %f", &pos[0], &pos[1], &pos[2]);
    } else if (!strcmp("model", ep->key)) {
      sscanf(ep->value, "%c%d", &aster, &model_num);
    } else if (!strcmp("angle", ep->key)) {
      sscanf(ep->value, "%d", &angle);
    } else if (!strcmp("speed", ep->key)) {
      sscanf(ep->value, "%d", &speed);
    } else if (!strcmp("spawnflags", ep->key)) {
      sscanf(ep->value, "%d", &spawnflags);
    }
  }

  // Verify we have a valid model
  if (model_num > 0 && model_num < bsp->num_models) {
    pfDCSTrans(bsp->model_dcs[model_num], pos[0], pos[1], pos[2]);
    if (speed != 0) {
      //fprintf(stderr, "speed: %d\n", speed);
      // was PFTRAV_CULL
      pfNodeTravFuncs(bsp->model_dcs[model_num], PFTRAV_APP, NULL,
		      _qkRotateCb);
      float *rotInfo = (float *) pfMalloc(sizeof(float)*4, pfGetSharedArena());
      rotInfo[0] = speed;
      rotInfo[1] = 0;
      rotInfo[2] = pfGetTime();
      rotInfo[3] = spawnflags;
      // was PFTRAV_CULL
      pfNodeTravData(bsp->model_dcs[model_num], PFTRAV_APP, rotInfo);
    }
  }

  // determine cluster
  pfMatrix mat;
  int leaf, cluster;
  float unused;
  pfGetDCSMat(bsp->model_dcs[model_num], (float(*)[4])&mat);
  pfGetMatRow(mat, 3, &pos[0], &pos[1], &pos[2], &unused);

  leaf = _findCurLeaf(pos, bsp);

  cluster = bsp->leaves[leaf].cluster;
  bsp->modelCluster[model_num] = cluster;

  return 0;
}

static void _invokeAllEntityCallbacks(quakeBsp *bsp)
{

  // If there are not entity callback skip the whole mess.
  if (pfGetNum(gQkEntityFuncList) > 0) {

    // Parse each entity.
    bsp->num_entities = 0;
    ParseFromMemory(bsp->entity_buf, bsp->len_entities);
    while (ParseEntity(bsp)) {
    }

    // Invode entity callbacks.
    for (int i = 0; i < bsp->num_entities; i++) {
      //PrintEntity(&bsp->entities[i]);
      _invokeEntityCallbacks(&bsp->entities[i]);
    }
  }
}


static int _clusterPostDraw(pfTraverser *trav, void *ud)
{
  pfList *gsets = (pfList *)ud;

  pfPushState();
  pfBasicState();

  //  glPushAttrib(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glBlendFunc(GL_ZERO, GL_SRC_COLOR);
  glEnable(GL_BLEND);
  glDepthFunc(GL_LEQUAL);

  for (int j = 0; j < pfGetNum(gsets); j++) {
    pfGeoSet *gs = (pfGeoSet *)pfGet(gsets, j);
    pfDrawGSet(gs);
  }

  glDisable(GL_BLEND);
  //  glPopAttrib();

  pfPopState();

  return PFTRAV_CONT;

}

static void  _parentModels(pfGroup *root, quakeBsp *bsp)
{
  //pfMatrix mat;
  //pfVec3 pos;
  int leaf, cluster;
  //float unused;
  //pfSphere sph;

  for (int j = 1; j < bsp->num_models; j++) {

    // wrong - many models already in world coords.
    //pfGetNodeBSphere(bsp->model_dcs[j], &sph);
    //pfCopyVec3(pos, sph.center);

    pfVec3 pos;
    pos[0] = (bsp->models[j].mins[0] + bsp->models[j].maxs[0])/2.0f;
    pos[1] = (bsp->models[j].mins[1] + bsp->models[j].maxs[1])/2.0f;
    pos[2] = (bsp->models[j].mins[2] + bsp->models[j].maxs[2])/2.0f;
    
    leaf = _findCurLeaf(pos, bsp);
    assert(leaf < bsp->num_leaves);
    assert(leaf > 0);

    cluster = bsp->leaves[leaf].cluster;
    assert(cluster < bsp->num_clusters);

    pfNotify(PFNFY_DEBUG, PFNFY_PRINT, "pfBsp: Model[%d] Pos: %f,%f,%f Cluster: %d\n", 
	     j, pos[0], pos[1], pos[2], cluster);

    // hasn't already been set (eg. in entity callback)
    if (bsp->modelCluster[j] == -1)
      bsp->modelCluster[j] = cluster;
    else // get cluster
      cluster = bsp->modelCluster[j];

    if (cluster < 0) {
      pfNotify(PFNFY_WARN, PFNFY_PRINT, "pfBsp: Model, %d, has negative cluster.\n", j);
      //fprintf(stderr, "model %d has negative cluster.\n", j);
      pfAddChild(root, bsp->model_dcs[j]);
    }
    else {
      if (bsp->cluster_leaves[cluster] == NULL)
        bsp->cluster_leaves[cluster] = (pfNode *)pfNewGroup();
      pfAddChild((pfGroup *)bsp->cluster_leaves[cluster], bsp->model_dcs[j]);
    }
  }


/**** this is now in entity callback
    if (cluster < 0) {
      // Model my be a rotating model.  Check its DCS for position and
      // reattempt to determine cluster.
      pfGetDCSMat(bsp->model_dcs[j], (float(*)[4])&mat);
      pfGetMatRow(mat, 3, &pos[0], &pos[1], &pos[2], &unused);

      leaf = _findCurLeaf(pos, bsp);
      assert(leaf < bsp->num_leaves);
      assert(leaf > 0);

      cluster = bsp->leaves[leaf].cluster;
      assert(cluster < bsp->num_clusters);

      pfNotify(PFNFY_DEBUG, PFNFY_PRINT, "pfBsp: Model[%d] Pos: %f,%f,%f Cluster: %d\n", 
	       j, pos[0], pos[1], pos[2], cluster);


      if (cluster < 0) {
	// Invalid cluster.
	pfNotify(PFNFY_WARN, PFNFY_PRINT, "pfBsp: Model, %d, has negative cluster.\n", j);
	pfAddChild(root, bsp->model_dcs[j]);
	continue;
      }
    }

    if (bsp->cluster_leaves[cluster] == NULL) {
      bsp->cluster_leaves[cluster] = (pfNode *)pfNewGroup();
    }

    pfAddChild((pfGroup *)bsp->cluster_leaves[cluster], bsp->model_dcs[j]);
  }
*****/
}

static void _optimizeSceneGraph(pfNode *root, quakeBsp *bsp)
{

  // Flatten cluster groups and geodes.
  for (int i = 0; i < bsp->num_clusters; i++) {

    if (bsp->cluster_leaves[i] == NULL) continue;

    // Remove cluster group if it only has a single child.
    // Move group trav callbacks and data to child node.

    int kids = pfGetNumChildren(bsp->cluster_leaves[i]);
    if (kids == 0) {
      // This should not happen.
    } else if (kids == 1) {

      // Move cluster callbacks to child.
      pfNodeTravFuncType preCb, postCb;
      void *cbData;

      pfGeode *cluster_geode = (pfGeode *)pfGetChild(bsp->cluster_leaves[i], 0);
      pfGetNodeTravFuncs(bsp->cluster_leaves[i], PFTRAV_DRAW, &preCb, &postCb);
      cbData = pfGetNodeTravData(bsp->cluster_leaves[i], PFTRAV_DRAW);

      pfNodeTravFuncs(cluster_geode, PFTRAV_DRAW, preCb, postCb);
      pfNodeTravData(cluster_geode, PFTRAV_DRAW, cbData);

      // Remove group from parent.
      pfRemoveChild(root, bsp->cluster_leaves[i]);
      pfRemoveChild(bsp->cluster_leaves[i], cluster_geode);

      // Delete this group.
      pfDelete(bsp->cluster_leaves[i]);

      // Make the geode the cluster leaf node.
      bsp->cluster_leaves[i] = (pfNode *)cluster_geode;

      // Add the geode to the scene
      pfAddChild(root, bsp->cluster_leaves[i]);

    }
  }

}

PF_DLLEXPORT qkBsp *qkGetBsp(void)
{
  return (qkBsp *)gBsp;
}

PF_DLLEXPORT int   qkGetIsectZ(qkBsp *bsp, pfVec3 pos, pfVec3 result)
{
  quakeBsp *qbsp = (quakeBsp *)bsp;

  int leaf = _findCurLeaf(pos, qbsp);

  fprintf(stdout, "Cur Leaf: %d  FirstLBrush: %d  NumLBrush: %d\n", 
	  leaf, qbsp->leaves[leaf].firstleafbrush, 
	  qbsp->leaves[leaf].numleafbrushes);

  for (int lf = qbsp->leaves[leaf].firstleafface; 
       lf < qbsp->leaves[leaf].firstleafface + 
	 qbsp->leaves[leaf].numleaffaces; lf++) {

    unsigned short cf = qbsp->leaf_faces[lf];

    fprintf(stdout, "Cur Face: %d\n", cf);

    unsigned short plane = qbsp->faces[cf].planenum;
    fprintf(stdout, "Plane: %d  %f,%f,%f %f\n", plane, 
	    qbsp->planes[plane].normal[0], qbsp->planes[plane].normal[1],
	    qbsp->planes[plane].normal[2], qbsp->planes[plane].dist);
  }

  return 0;
}

static int _updatePreApp(pfTraverser *trav, void *data)
{
  quakeBsp *bsp = (quakeBsp *)data;

  for (int i = 0; i < bsp->num_texinfo; i++) {
    if (bsp->texmats[i]) {
      pfPostTransMat(*bsp->texmats[i], *bsp->texmats[i], 0.01f, 0.00f, 0.0f);
    }
  }
  return 0;
}
