/*
 ============================================================================
    $Revision: 1.0 $        $Date: 1997/11/20 15:01:26 $
 ============================================================================

                      PARADIGM SIMULATION, INCORPORATED
               Copyright (c) 1993-1997 by Paradigm Simulation, Inc.

           This software is licensed and not sold. All use of this
           software is subject to the terms and conditions of the PSI
           software license, which should be read carefully. Copyright
           infringement is a serious and criminal offense.
           For more information, contact Paradigm Simulation at
           1-972-960-2301 or send e-mail to support@paradigmsim.com.

  ============================================================================
*/


#ifndef __PF_BSP_H__
#define __PF_BSP_H__

#ifdef WIN32
#include <pf.h>
#endif

#ifndef WIN32
#if PF_CPLUSPLUS_API
//class pfNode;
#else
//typedef struct _pfNode pfNode;
#endif
#define PF_DLLEXPORT
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * defines for pfdConverterMode_bsp
 */
#define PFBSP_PALETTED_TEXTURES    0
#define PFBSP_RANDOM_LEAF_COLORS   1
#define PFBSP_USE_LIGHTMAPS        2

/*
 * defines for pfdConverterVal_bsp
 */


/*
 * defines for pfdConverterAttr_bsp
 */

/*
 * default intersection traversal masks
 */
#define PFBSP_ISECT_MASK_SOLID     0x8000
#define PFBSP_ISECT_MASK_WINDOW    0x4000
#define PFBSP_ISECT_MASK_AUX       0x2000
#define PFBSP_ISECT_MASK_LAVA      0x1000
#define PFBSP_ISECT_MASK_SLIME     0x0800
#define PFBSP_ISECT_MASK_WATER     0x0400
#define PFBSP_ISECT_MASK_MIST      0x0200

PF_DLLEXPORT void     pfdInitConverter_bsp(void);
PF_DLLEXPORT pfNode *pfdLoadFile_bsp(const char *fileName, float gamma);
PF_DLLEXPORT int     pfdStoreFile_bsp(pfNode *root, const char *fileName);
PF_DLLEXPORT void    pfdConverterMode_bsp(int mode, int value);
PF_DLLEXPORT int     pfdGetConverterMode_bsp(int mode);
PF_DLLEXPORT void    pfdConverterVal_bsp(int which, float val);
PF_DLLEXPORT float   pfdGetConverterVal_bsp(int which);
PF_DLLEXPORT void    pfdConverterAttr_bsp(int which, void *attr);
PF_DLLEXPORT void*   pfdGetConverterAttr_bsp(int which);

/*
 * Entity callbacks
 */

typedef struct epair_s
{
  struct epair_s	*next;
  unsigned int ikey;
  char	*key;
  char	*value;
} epair_t;


typedef struct
{
  epair_t		*epairs;
} entity_t;


typedef int (qkEntityCb)(entity_t *entity, void *data);

PF_DLLEXPORT int     qkEntityFunc(const char *classname, qkEntityCb *func, void *data);

/*
 * BSP Utilities.
 */

typedef struct _qkBsp qkBsp;

PF_DLLEXPORT qkBsp *qkGetBsp(void);
PF_DLLEXPORT int   qkGetIsectZ(qkBsp *bsp, pfVec3 pos, pfVec3 result);
// PAUL!!!
PF_DLLEXPORT int   qkFindCurCluster(float *eyePos, qkBsp *bsp);

#ifdef __cplusplus
}
#endif

#endif
