#ifndef __PFBSP_INT_H__
#define __PFBSP_INT_H__

#ifdef WIN32
#include <pf.h>
#else
#include <Performer/pf.h>
#endif
#include "pfbsp.h"
#include "qfiles.h"

#if !PF_CPLUSPLUS_API
#define PFSTRUCT_DECLARE 			      \
public:						      \
    void* operator new(size_t s) {		      \
	return pfMalloc(s, pfGetSharedArena());	      \
    }      					      \
    void* operator new(size_t s, void *arena) {	      \
	return pfMalloc(s, arena);                    \
    }						      \
    void  operator delete(void *d) {		      \
	pfFree(d);			              \
    }                                                 \

#endif

typedef struct {
  int width;
  int height;
} texdims_t;


typedef struct
{
  short texsize[2];  // Size of light map.  One per face.
  float mins[2];
  float maxs[2];
} lightmap_t;

typedef struct
{
  int ofs[2];
} offset_t;

typedef struct 
{
  pfGeoState *gst; 
  int offset[2]; // BSP offset.
  GLubyte origin[2];
  GLubyte size[2];
} lighttex_t;

struct quakeBsp {
public:						      
  void* operator new(size_t s) {		      
    return pfMalloc(s, pfGetSharedArena());	      
  }      					      
  void* operator new(size_t s, void *arena) {	      
    return pfMalloc(s, arena);                    
  }						      
  void  operator delete(void *d) {		      
    pfFree(d);			              
  }						      

  int num_planes;
  dplane_t *planes;

  int num_models;
  dmodel_t *models;
  pfDCS **model_dcs;
  int *modelCluster;

  int num_verts;
  pfVec3 *verts;

  int num_edges;
  dedge_t *edges;

  int num_sedges;
  int *sedges;

  int num_faces;
  dface_t *faces;
  lightmap_t *lightmaps;
  int *used_faces;

  int num_texinfo;
  texinfo_t *texinfo;
  pfGeoState **gstates;
  pfMatrix **texmats;
  texdims_t *texdims;

  int num_nodes;
  dnode_t *nodes;

  int num_clusters;
  offset_t *cluster_ofs;
  GLubyte *vis_lists;
  pfNode **cluster_leaves;
  pfGeode **cluster_geodes;

  int num_leaves;
  dleaf_t *leaves;
  
  int num_lfaces;
  unsigned short *leaf_faces;

  int num_areas;
  darea_t *areas;

  int num_portals;
  dareaportal_t *portals;

  int num_lbrushes;
  unsigned short *leaf_brushes;

  int num_brushes;
  dbrush_t *brushes;

  int num_bsides;
  dbrushside_t *bsides;

  int len_entities;
  char *entity_buf;

  int num_entities;
  entity_t *entities;

  int len_lightmaps;
  unsigned char *lightdata;
  lighttex_t **lighttex; // One entry per face.
  pfList *qklightmaps;  // List of mosaic'ed lightmap pfTextures.
};

#endif
