/*
 ============================================================================
    $Revision: 1.0 $        $Date: 1997/11/20 15:01:26 $
 ============================================================================

                      PARADIGM SIMULATION, INCORPORATED
               Copyright (c) 1998 by Paradigm Simulation, Inc.

           This software is licensed and not sold. All use of this
           software is subject to the terms and conditions of the PSI
           software license, which should be read carefully. Copyright
           infringement is a serious and criminal offense.
           For more information, contact Paradigm Simulation at
           1-972-960-2301 or send e-mail to support@paradigmsim.com.

  ============================================================================
*/

#include "animation.h"
#include <Performer/pr/pfFlux.h>

pfType* md2Action::classType = NULL;

md2Action::md2Action()
{

}

md2Action::~md2Action()
{

}

void md2Action::init()
{
  if (classType == NULL) {
    pfObject::init();
    classType = new pfType(pfObject::getClassType(), "md2Action");
  }
}

void md2Action::setRange(int start, int end)
{
  start_frame = start;
  end_frame = end;
}

void md2Action::getRange(int &start, int &end)
{
  start = start_frame;
  end = end_frame;
}

pfType *md2Animation::classType = NULL;

md2Animation::md2Animation()
{
  actions = new pfList(sizeof(void *), 5);
  num_frames = 0;
  cur_action = 0;
  stop_flag = 0;
  interrupt_flag = 0;
}

md2Animation::~md2Animation()
{
  // Delete the each action as well.
  delete actions;
}

void md2Animation::init()
{
  if (classType == NULL) {
    pfObject::init();
    classType = new pfType(pfObject::getClassType(), "md2Animation");
  }

}

int md2Animation::addAction(int start, int end)
{
  md2Action *action = new md2Action;
  
  action->setRange(start, end);
  actions->add((void *)action);
  return (actions->getNum()-1);
}

int md2Animation::getNumActions()
{
  return actions->getNum();
}

int md2Animation::playAction(int ndx)
{
  stop_flag = 0;
  new_action = 1;
  next_action = ndx;
  return 0;
}

void md2Animation::setStop()
{
  stop_flag = 1;
}

void md2Animation::setInterrupt()
{
  interrupt_flag = 1;
}

int md2Animation::getCurrFrame()
{
  md2Action *action = (md2Action *) actions->get(cur_action);

  int start, end;
  action->getRange(start, end);

//  float frame_val = fmodf(((float)pfGetTime() * 5.0f), (float)(end-start)) + (float)start;
  float frame_val = fmodf((((float)pfGetTime()+timeS[0]) * timeS[1]), timeS[2]) + timeS[3];

  return (int) frame_val;
}

void md2Animation::update()
{
  float *time_scale;
  static float old_frame_val = 0.0;

  if ((!new_action && !stop_flag) || num_frames == 1) return;
  //if (!new_action || num_frames == 1) return;

  md2Action *action = (md2Action *)actions->get(cur_action);

  int start, end;
  action->getRange(start, end);
  
//  float frame_val = fmodf(((float)pfGetTime() * 5.0f), (float)(end-start)) + (float)start;
  float frame_val = fmodf((((float)pfGetTime()+timeS[0]) * timeS[1]), timeS[2]) + timeS[3];
  // fprintf(stderr, "frame_val: %f\n", frame_val);

  // look for engine to loop back before changing action
//  if (!interrupt_flag && (frame_val > old_frame_val) && cur_action != 0) {
  if (!interrupt_flag && (frame_val < (timeS[3]+timeS[2]-1)) && cur_action != 0) {
    old_frame_val = frame_val;
    return;
  }
  interrupt_flag = 0;
  old_frame_val = 0.0f;

  cur_action = next_action;

  action = (md2Action *)actions->get(cur_action);

  action->getRange(start, end);

  if (!new_action && stop_flag) {
    start = end - 1;
    stop_flag = 0;
  }

  time_scale = (float *)frame_control->getWritableData();
 
//  time_scale[0] = 0.0f;
  // dst = fmodf(t + s[0]) * s[1], s[2]) + s[3];
  time_scale[0] = -pfGetTime(); // offset engine to start at beginning
  time_scale[1] = 7.0f; // was 5.0
  time_scale[2] = (float)(end - start);
  time_scale[3] = (float)start;

  timeS[0] = time_scale[0]; 
  timeS[1] = time_scale[1]; 
  timeS[2] = time_scale[2]; 
  timeS[3] = time_scale[3]; 

  frame_control->writeComplete();

  float *loop_bounds;

  loop_bounds = (float *)loop_control->getWritableData();
  loop_bounds[0] = (float)start;
  loop_bounds[1] = (float)end;
  loop_control->writeComplete();

  //cur_action = next_action;
  new_action = 0; // Paul
}


extern "C" {
  int md2GetAnimNumFrames(md2Animation *anim)
    {
      return anim->getNumFrames();
    }
  int md2AnimAddAction(md2Animation *anim, int start, int end)
    {
      return anim->addAction(start, end);
    }
  int md2AnimPlayAction(md2Animation *anim, int action)
    {
      return anim->playAction(action);
    }
  int md2GetAnimNumActions(md2Animation *anim)
    {
      return anim->getNumActions();
    }
}

