/*
 ============================================================================
    $Revision: 1.0 $        $Date: 1997/11/20 15:01:26 $
 ============================================================================

                      PARADIGM SIMULATION, INCORPORATED
               Copyright (c) 1998 by Paradigm Simulation, Inc.

           This software is licensed and not sold. All use of this
           software is subject to the terms and conditions of the PSI
           software license, which should be read carefully. Copyright
           infringement is a serious and criminal offense.
           For more information, contact Paradigm Simulation at
           1-972-960-2301 or send e-mail to support@paradigmsim.com.

  ============================================================================
*/


#ifndef __PFMD2_ANIMATION__
#define __PFMD2_ANIMATION__

#include <Performer/pr/pfObject.h>
#include <Performer/pr/pfList.h>


class md2Action : public pfObject
{
public:
  md2Action();
  virtual ~md2Action();

  // per class functions;
  static void    init();
  static pfType* getClassType() { return classType; }

  void setRange(int start, int end);
  void getRange(int &start, int &end);

protected:

  int start_frame;
  int end_frame;

private:
  static pfType *classType;
};

class md2Animation : public pfObject 
{
public:

  md2Animation();
  virtual ~md2Animation();

  // per class functions;
  static void    init();
  static pfType* getClassType() { return classType; }

  void setFrameControl(pfFlux *cntl, pfFlux *loop) { frame_control = cntl; loop_control = loop; };
  
  void setNumFrames(int num) { num_frames = num; };
  int getNumFrames() { return num_frames; };

  int addAction(int start, int end);
  int getNumActions();
  int playAction(int ndx);
  void setStop(); // Paul - play next action to its end and stop
  int getCurrFrame(); // Paul
  void setInterrupt(); // Paul - interrupt current action and do next one
  int getCurrAction() { return cur_action; } // Paul

  void update();

protected:

  pfFlux *frame_control;
  pfFlux *loop_control;
  int num_frames;
  pfList *actions;
  int new_action;
  int cur_action;
  int next_action;
  int stop_flag; // Paul
  int interrupt_flag; // Paul
  float timeS[4]; // Paul

private:
  static pfType *classType;
};

#endif
