/*
 ============================================================================
    $Revision: 1.0 $        $Date: 1997/11/20 15:01:26 $
 ============================================================================

                      PARADIGM SIMULATION, INCORPORATED
               Copyright (c) 1998 by Paradigm Simulation, Inc.

           This software is licensed and not sold. All use of this
           software is subject to the terms and conditions of the PSI
           software license, which should be read carefully. Copyright
           infringement is a serious and criminal offense.
           For more information, contact Paradigm Simulation at
           1-972-960-2301 or send e-mail to support@paradigmsim.com.

  ============================================================================
*/


#ifndef __PF_MD2_H__
#define __PF_MD2_H__

#ifdef __cplusplus
extern "C" {
#endif

/*
 * defines for pfdConverterMode_md2
 */
#define PFMD2_ANIMATION          0
#define PFMD2_DUMP_ACTIONS       1
#define PFMD2_Z_CLAMP            2
#define PFMD2_USER_DATA_SLOT     3

/*
 * values for PFMD2_ANIMATION
 */
#define PFMD2_ANIMATION_SEQUENCE 0
#define PFMD2_ANIMATION_MORPH    1

/*
 * defines for pfdConverterVal_md2
 */


/*
 * defines for pfdConverterAttr_md2
 */

void     pfdInitConverter_md2(void);
pfNode *pfdLoadFile_md2(const char *fileName);
int     pfdStoreFile_md2(pfNode *root, const char *fileName);
void    pfdConverterMode_md2(int mode, int value);
int     pfdGetConverterMode_md2(int mode);
void    pfdConverterVal_md2(int which, float val);
float   pfdGetConverterVal_md2(int which);
void    pfdConverterAttr_md2(int which, void *attr);
void*   pfdGetConverterAttr_md2(int which);


/*
 * Amimation API.
 *
 */

#ifdef __cplusplus
class md2Animation;
#else
typedef struct _md2Animation md2Animation;
#endif

md2Animation *md2GetNodeAnimation(pfNode *md2node);
int md2GetAnimNumFrames(md2Animation *anim);
int md2AnimAddAction(md2Animation *anim, int start, int end);
int md2AnimPlayAction(md2Animation *anim, int action);
int md2GetAnimNumActions(md2Animation *anim);

#ifdef __cplusplus
}
#endif

#endif
