//====================================================================
//#
//#  CaveQuakeArmor.h                                 ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#ifndef CAVE_QUAKE_ARMOR_H
#define CAVE_QUAKE_ARMOR_H

#include "CaveQuakeItem.h"

class CaveQuakeArmor : public CaveQuakeItem {

public:

  CaveQuakeArmor() { fprintf(stderr, "DO NOT USE THIS CONSTRUCTOR!\n"); }
  CaveQuakeArmor(float xx, float yy, float zz, int respawn) : CaveQuakeItem("models/items/armor/combat/tris.md2", xx, yy, zz, respawn) {
  }

  virtual void update() {
    CaveQuakeItem::update();
    dcs->setRot(pfGetTime()*-80.0f, 0.0f, 0.0f);
  }

  // make sound... affect player
  virtual void gotItem() {
    if (player->getArmor() >= 100) {
      visible = 1;
      return;
    }
    fprintf(stderr, "ARMOR!\n");
    quakeSound("pArmor", 2.0f);
    player->setArmor(player->getArmor()+50);
    if (player->getArmor() > 100)
      player->setArmor(100);
    char armorVal[64];
    sprintf(armorVal, "%d", player->getArmor());
    player->getArmorStr()->setString(armorVal);
  }
}; 

#endif
