//====================================================================
//#
//#  CaveQuakeBerserk.h                               ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#include "CaveQuakeMonster.h"

#ifndef CAVE_QUAKE_BERSERK_H
#define CAVE_QUAKE_BERSERK_H

class CaveQuakeBerserk : public CaveQuakeMonster {

public:

  CaveQuakeBerserk() : CaveQuakeMonster("models/monsters/berserk/tris.md2") {
    initActions();
    //fprintf(stderr, "NUMBER OF ACTIONS: %d\n", anim->getNumActions());
    //WALKSPEED = 4.0;
    //RUNSPEED = 8.0;
    WALKSPEED = 4.0*7.0/5.0;
    RUNSPEED = 8.0*7.0/5.0;
    lastFrame = 0;
  }

  virtual void update() {
    // play sounds according to frame number!
    // set speed of movement according to frame number!!
    int frame = anim->getCurrFrame();
//    if (frame != lastFrame)
//      fprintf(stderr, "frame: %d\n", frame);

    // will only happen once per key frame
    if (frame != lastFrame) {
      if (frame == 78 || frame == 48 || frame == 66 || frame == 88)
        quakeSound("bAttackP", this->distanceFromEnemy());
      if (frame == 79 || frame == 50 || frame == 68 || frame == 90)
         fire(20);
         //fire(10);
      if (frame == 101)
        quakeSound("bAttack", this->distanceFromEnemy());
      if (frame == 104)
        fire(40);
        //fire(30);
      if (frame == 9 || frame == 13)
        quakeSound("bIdle1", this->distanceFromEnemy()/2.0f);
      if (frame == 1) {
        int doit = rand()%20;
        if (doit > 15)
          quakeSound("bIdle", this->distanceFromEnemy());
      }
      if (frame == 200)
        quakeSound("bPain", this->distanceFromEnemy()+30.0f);
      //if (frame == 225)
      //  quakeSound("bDeath", this->distanceFromEnemy());

      // monster speeds
      if (frame >= 0 && frame <= 24) setSpeed(0.0); // stand (2)
      else if (frame >= 25 && frame <= 35) setSpeed(WALKSPEED); // walk
      else if (frame >= 36 && frame <= 41) setSpeed(RUNSPEED); // run
      else if (frame >= 42 && frame <= 109) setSpeed(0.0); // attacks
      else if (frame >= 110 && frame <= 145) setSpeed(RUNSPEED); // run attacks
      else if (frame >= 146 && frame <= 243) setSpeed(0.0); // rest of actions
    }
    lastFrame = frame;

    CaveQuakeMonster::update();
  }

  virtual void initActions() {
    STAND = anim->addAction(0, 4);
    anim->addAction(5, 24);
    WALK = anim->addAction(25, 35);
    RUN = anim->addAction(36, 41);
    ATTACK = anim->addAction(42, 54);
    anim->addAction(55, 75);
    anim->addAction(76, 109);  // big attack
    anim->addAction(110, 127); // run attack
    anim->addAction(128, 145); // run attack
    anim->addAction(146, 168); // fall attack
    DUCK = anim->addAction(169, 178);
    FALL = anim->addAction(179, 198);
    PAIN = anim->addAction(199, 202);
    //anim->addAction(203, 222); // reuse same pain
    anim->addAction(199, 202);  
    DEATH = anim->addAction(223, 235);
    anim->addAction(236, 243);
  }

  virtual void ai() {
    CaveQuakeMonster::ai();

    if (life <= 0) return;

    // overide base class behavior 
    if (mood == M_ANGRY_RAND) {
      int decide = rand()%25;
      if (decide > 10 && decide < 14) mood = M_ANGRY;
      if (SPEED > 0.0f) {
        if (decide == 15 || decide == 16) rotLeft();
        if (decide == 17 || decide == 18) rotRight();
        if (decide == 19) rotStop();
      }
      else
        rotStop();
    }

    if (mood == M_ANGRY && distanceFromEnemy() > 10.0f) {
      int decide = rand()%20;
      if (decide == 10 || decide == 12) {
        decide = rand()%2;
        if (decide == 0)
          rotLeft();
        else
          rotRight();
        mood = M_ANGRY_RAND;
      }
    }

    //if (distanceFromEnemy() <= 4.0f) {
    if (distanceFromEnemy() <= 10.0f) {
      int i = rand()%3;
      attack(i);
    }
    else if (mood == M_ANGRY)
      run();
  }

  virtual void sight() {
    if (mood == M_FRIENDLY)
      quakeSound("bSight", this->distanceFromEnemy());
    CaveQuakeMonster::sight();
  }
  void fire(int damage) {
    if (enemy == NULL) return;
    //if (distanceFromEnemy() <= 5.0f)
    if (distanceFromEnemy() <= 10.0f) {
      enemy->hit(damage);
      CaveQuakePlayer *p = (CaveQuakePlayer *) enemy;
      // dir and magnitude
      p->setVel(dx, dy, 1.0f, 20.0f);
    }
  }
};

#endif
