//====================================================================
//#
//#  CaveQuakeGunner.h                                ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#include "CaveQuakeMonster.h"

#ifndef CAVE_QUAKE_GUNNER_H
#define CAVE_QUAKE_GUNNER_H

class CaveQuakeGunner : public CaveQuakeMonster {

public:

  CaveQuakeGunner() : CaveQuakeMonster("models/monsters/gunner/tris.md2") {
    initActions();
    //fprintf(stderr, "NUMBER OF ACTIONS: %d\n", anim->getNumActions());
    //WALKSPEED = 3.0;
    //RUNSPEED = 6.0;
    WALKSPEED = 3.0*7.0/5.0;
    RUNSPEED = 6.0*7.0/5.0;
    life = 120;
    lastFrame = 0;
  }

  virtual void update() {

    int frame = anim->getCurrFrame();
//    fprintf(stderr, "frame: %d\n", frame);
    if (frame != lastFrame) {
//      cout << "frame: " << frame << endl;

      // sounds
      if (frame == 111 || frame == 114 || frame == 117 || frame == 120)
        quakeSound("gAttack4", this->distanceFromEnemy());
      else if (frame > 142 && frame < 154)
        quakeSound("gAttack2", this->distanceFromEnemy());
      else if (frame == 124)
        quakeSound("gAttack1", this->distanceFromEnemy());
      else if (frame == 140)
        quakeSound("gAttack3", this->distanceFromEnemy());
      else if (frame == 4) {
        int doit = rand()%20;
        if (doit > 15)
          quakeSound("gSearch", this->distanceFromEnemy());
      }
      else if (frame == 179)
        quakeSound("gPain1", this->distanceFromEnemy());
      else if (frame == 161)
        quakeSound("gPain2", this->distanceFromEnemy());
      else if (frame == 187)
        quakeSound("gPain1", this->distanceFromEnemy());

      // damage
      if (frame == 113 || frame == 116 || frame == 119 || frame == 122)
        fire(10);
      else if (frame == 143 || frame == 146 || frame == 149 || frame == 152 || frame == 155)
        fire(3);

      // monster speeds
      if (frame >= 0 && frame <= 69) setSpeed(0.0);
      else if (frame >= 70 && frame <= 85) setSpeed(WALKSPEED);
      else if (frame >= 86 && frame <= 93) setSpeed(0.0);
      else if (frame >= 94 && frame <= 107) setSpeed(RUNSPEED);
      else if (frame >= 108 && frame <= 208) setSpeed(0.0);
    }
    lastFrame = frame;

    CaveQuakeMonster::update();
  }

  virtual void initActions() {
    STAND = anim->addAction(0, 6);
    anim->addAction(0, 69);
    WALK = anim->addAction(70, 93);
    RUN = anim->addAction(94, 101);
    anim->addAction(102, 107);
    ATTACK = anim->addAction(108, 128);
    anim->addAction(129, 158);
    PAIN = anim->addAction(159, 176);
    anim->addAction(177, 184);
    anim->addAction(185, 189);
    DEATH = anim->addAction(190, 200);
    DUCK = anim->addAction(201, 208);
  }

  virtual void random() {
    CaveQuakeMonster::random();
 
    if (anim->getCurrAction() == WALK)
      run();
    if (anim->getCurrAction() == (STAND+1))
      stand();
  }

  virtual void ai() {
    CaveQuakeMonster::ai();

    if (life <= 0) return;
    if (mood == M_ANGRY_RAND)
      run();
    else if (distanceFromEnemy() <= 35.0f) {
      sight();
      int i = rand()%2;
      attack(i);
    }
    else if (mood == M_ANGRY)
      run();
  }

  virtual void sight() {
    if (mood == M_FRIENDLY)
      quakeSound("gSight", this->distanceFromEnemy());
    //mood = M_ANGRY;
    CaveQuakeMonster::sight();
  }

  virtual void two() { attack(1); }
  virtual void three() { run(); }

  virtual void fire(int damage) {
//    fprintf(stderr, "fD: %f eD: %f\n", forwardHitD, distanceFromEnemy());
    //if (forwardHitD > (distanceFromEnemy()-1.0f))
//    if (lineSightD > (distanceFromEnemy()-1.0f))
    if (inSight())
      enemy->hit(damage);
  }
};

#endif
