//====================================================================
//#
//#  CaveQuakeHealth.h                                ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#ifndef CAVE_QUAKE_HEALTH_H
#define CAVE_QUAKE_HEALTH_H

#include "CaveQuakeItem.h"

class CaveQuakeHealth : public CaveQuakeItem {

public:

  CaveQuakeHealth() { fprintf(stderr, "DO NOT USE THIS CONSTRUCTOR!\n"); }
  CaveQuakeHealth(float xx, float yy, float zz, int respawn) : CaveQuakeItem("models/items/healing/medium/tris.md2", xx, yy, zz, respawn) {
  }

  // make sound... affect player
  virtual void gotItem() {
    if (player->getLife() >= 100) {
      visible = 1;
      return;
    }
    fprintf(stderr, "HEALTH!\n");
    quakeSound("pHealth", 2.0f);
    player->setLife(player->getLife()+25);
    if (player->getLife() > 100)
      player->setLife(100);
    char lifeVal[64];
    sprintf(lifeVal, "%d", player->getLife());
    player->getStr()->setString(lifeVal);
  }
}; 

#endif
