//====================================================================
//#
//#  CaveQuakeInfantry.h                              ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#include "CaveQuakeMonster.h"

#ifndef CAVE_QUAKE_INFANTRY_H
#define CAVE_QUAKE_INFANTRY_H

class CaveQuakeInfantry : public CaveQuakeMonster {

private:
  int bulletCounter;

public:

  CaveQuakeInfantry() : CaveQuakeMonster("models/monsters/infantry/tris.md2") {
    initActions();
    //fprintf(stderr, "NUMBER OF ACTIONS: %d\n", anim->getNumActions());
    //WALKSPEED = 2.0;
    //RUNSPEED = 5.0;
    WALKSPEED = 2.0*7.0/5.0;
    RUNSPEED = 5.0*7.0/5.0;
    life = 60;
    lastFrame = 0;
    bulletCounter = 4;
  }

  virtual void reset() {
    CaveQuakeMonster::reset();
    life = 60;
  }

  virtual void update() {
   int frame = anim->getCurrFrame();
    if (frame != lastFrame) {
//      if (CAVEBUTTON2)
//        cout << "frame: " << frame << endl;

      // sounds
      if (frame == 50 || frame == 4) {
        int doit = rand()%20;
        if (doit > 16)
          quakeSound("iIdle", this->distanceFromEnemy());
      }
      else if (frame == 134)
        quakeSound("iDeath", this->distanceFromEnemy());
      else if (frame == 108)
        quakeSound("iPain", this->distanceFromEnemy());
      else if (frame == 119)
	quakeSound("iPain2", this->distanceFromEnemy());
      else if (frame == 195)
	quakeSound("iCock", this->distanceFromEnemy());
      else if (frame == 201 || frame == 101 || frame == 103)
	quakeSound("iFire", this->distanceFromEnemy());
      else if (frame == 210)
	quakeSound("iSwing", this->distanceFromEnemy());

      // damage
      if (frame == 203 || frame == 103 || frame == 105)
        fire(4);
      else if (frame == 211)
	swing(15);

      // speed
      if (frame >= 0 && frame <= 70) setSpeed(0.0);
      else if (frame >= 71 && frame <= 90) setSpeed(WALKSPEED);
      else if (frame >= 91 && frame <= 106) setSpeed(RUNSPEED);
      else if (frame >= 107) setSpeed(0.0);
    }
    lastFrame = frame;

    CaveQuakeMonster::update();
  }

  virtual void ai() {
    CaveQuakeMonster::ai();

    if (life <= 0) return;
    if (distanceFromEnemy() <= 4.0f)
      attack(1);
    else if (mood == M_ANGRY || mood == M_ANGRY_RAND) {
      if (bulletCounter <= 0) {
        attack(); // reloads and then fires...
	anim->setInterrupt();
        bulletCounter = 6;
      }
      else
        run(); // running and shooting
    }
  }

  virtual void sight() {
    if (mood == M_FRIENDLY)
      quakeSound("iSight", this->distanceFromEnemy());
    CaveQuakeMonster::sight();
  }

  virtual void fire(int damage) {
    if (enemy == NULL) return;
    //if (forwardHitD > (distanceFromEnemy()-1.0f))
    //if (lineSightD > (distanceFromEnemy()-1.0f))
    if (inSight())
      enemy->hit(damage);
    bulletCounter--;
  }
  
  virtual void swing(int damage) {
    //cout << "swing" << endl;
    if (distanceFromEnemy() <= 5.0f)
      enemy->hit(damage);
  }

  virtual void initActions() {
    //STAND = anim->addAction(1, 47);
    STAND = anim->addAction(48, 70);
    anim->addAction(1, 47);
    WALK = anim->addAction(71, 90);
    RUN = anim->addAction(91, 106);
    PAIN = anim->addAction(107, 117);
    anim->addAction(118, 126);
    DUCK = anim->addAction(127, 131);
    DEATH = anim->addAction(132, 152);
    anim->addAction(153, 178);
    anim->addAction(179, 190);
    // BLOCK
    ATTACK = anim->addAction(191, 207);
    anim->addAction(208, 213);
  }
};

#endif
