//====================================================================
//#
//#  CaveQuakeItem.h                                  ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#ifndef CAVE_QUAKE_ITEM_H
#define CAVE_QUAKE_ITEM_H

#include <Performer/pf/pfDCS.h>
#include <Performer/pf/pfSwitch.h>
#include <Performer/pf/pfTraverser.h>
#include <Performer/pr/pfGeoSet.h>
#include "pfmd2.h"
#include "pfbsp.h"
#include "animation.h"
#include "defs.h"

#include "utils.h"
#include "CaveQuakeBeing.h"

extern CaveQuakePlayer *player;

class CaveQuakeItem {

protected:

  pfNode *item;
  pfDCS *dcs;
  float X, Y, Z;
  float pickedUpTime, respawnTime, lastTime;
  int visible;
  
public:

  CaveQuakeItem() { fprintf(stderr, "DO NOT USE THIS CONSTRUCTOR!\n"); }
  CaveQuakeItem(char *filename, float xx, float yy, float zz, float r=30.0f) {
    item = pfdLoadFile_md2(filename);
    X = xx; Y = yy; Z = zz;
    respawnTime = r;
    visible = 1;
    dcs = new pfDCS;
    dcs->setScale(0.1f, 0.1f, 0.1f);
    dcs->setTrans(X, Y, Z);
    dcs->addChild(item);
    lastTime = pfGetTime();
  }

  pfNode *getRoot() { return dcs; }

  virtual float distanceFromPlayer() {
    if (player != NULL) {
      pfVec3 itemPos(X, Y, Z);
      pfVec3 playerPos(player->X, player->Y, player->Z);
      return playerPos.distance(itemPos);
    }
    else
      return 1000.0f; 
  }

  virtual float distanceFromOpponent() {
    return 1000.0f;
  }

  virtual void update() {
    float thisTime = pfGetTime();
    // check once in a while...
    if (thisTime - lastTime > 0.4f) {
      lastTime = thisTime;
      if (visible) {
        dcs->setTravMask(PFTRAV_DRAW, 0xFFFFFFFF, PFTRAV_DESCEND, PF_SET);
        dcs->setTravMask(PFTRAV_ISECT, 0xFFFF, PFTRAV_DESCEND, PF_SET);
        if (distanceFromPlayer() < 4.0f) {
          visible = 0;
          gotItem();
          pickedUpTime = pfGetTime();
        }
      }
      else {
        dcs->setTravMask(PFTRAV_DRAW, 0x0, PFTRAV_DESCEND, PF_SET);
        dcs->setTravMask(PFTRAV_ISECT, 0x0, PFTRAV_DESCEND, PF_SET);
        if (thisTime - pickedUpTime > respawnTime) {
          // play sound
          quakeSound("pRespawn", distanceFromPlayer());
          visible = 1;
        }
      }
    }
  }

  // make sound... affect player
  virtual void gotItem() = 0;
}; 

#endif
