//====================================================================
//#
//#  CaveQuakeMonster.h                               ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#ifndef CAVE_QUAKE_MONSTER_H
#define CAVE_QUAKE_MONSTER_H

#ifdef USE_CAVELIB
#include <pfcave.h>
#else
#include "pfcaveAlt.h"
#endif
#include <Performer/pf/pfDCS.h>
#include <Performer/pf/pfSwitch.h>
#include <Performer/pf/pfTraverser.h>
#include <Performer/pr/pfGeoSet.h>
#include "pfmd2.h"
#include "pfbsp.h"
#include "animation.h"
#include "defs.h"

#include "utils.h"
#include "CaveQuakeBeing.h"

#define M_NORMAL 0
#define M_FALLING 1
#define M_GRAVITY 16.0

#define M_ANGRY 0
#define M_FRIENDLY 1
#define M_DEAD 2
#define M_ANGRY_RAND 3  // a little randomness to angriness. :)

class CaveQuakeMonster : public CaveQuakeBeing {

protected:
  pfNode *monster;
  pfDCS *dcs;
  md2Animation *anim;
  int ATTACK, DUCK, PAIN, RUN, STAND, WALK, DEATH, FALL;
  //float rotH, transY, transX, transZ, dx, dy;
  float saveX, saveY, saveZ;
  float dx, dy;
  float SPEED, WALKSPEED, RUNSPEED; 
  CaveQuakeBeing *enemy;
  pfSegSet segset;
  float forwardHitD, vSpeed, lineSightD;
  int state, mood; // life;
  int painCounter;
  float lastTime, angryTime, sightTime;
  int lastFrame;

public:
  float ROTSPEED;
  CaveQuakeMonster() { fprintf(stderr, "DO NOT USE THIS CONSTRUCTOR!\n"); }
  CaveQuakeMonster(char *filename);

  virtual void initActions() = 0;
  virtual void initPos();
  virtual void reset();

  // SAVE/RESTORE POS
  void savePos() { saveX = X; saveY = Y; saveZ = Z; }
  void restorePos() { X = saveX; Y = saveY; Z = saveZ; }

  // GET METHODS 
  int inSight();
  float cosAngleFromEnemy();
  float distanceFromEnemy();
  int getMood() { return mood; }
  pfNode *getRoot() { return dcs; }
  md2Animation *getAnim() { return anim; }
  float getWalkSpeed() { return WALKSPEED; }
  float getRunSpeed() { return RUNSPEED; }

  // SET METHODS
  void setEnemy(CaveQuakeBeing *theEnemy) { enemy = theEnemy; }
  void setSpeed(float newSpeed) { SPEED = newSpeed; }
  void setWalkSpeed(float newSpeed);
  void setRunSpeed(float newSpeed);
  void setTrans(float x, float y, float z);
  void setRot(float h, float p, float r);

  // UPDATE (sounds, translation)
  virtual void update();
  virtual void random();
  virtual void ai();
  //virtual void isect(pfDCS *level);
  virtual void isect(pfNode *level);
  virtual void hit(int damage);

  // ROTATION
  void rotRight() { ROTSPEED = -60.0; }
  void rotLeft() { ROTSPEED = 60.0; }
  void rotStop() { ROTSPEED = 0.0; }

  // ACTIONS
  virtual void one() { stand(); }
  virtual void two() { attack(); }
  virtual void three() { walk(); }
  virtual void sight() {
    if (mood == M_FRIENDLY)
      mood = M_ANGRY;
    angryTime = pfGetTime();
  }
  virtual void all() { anim->playAction(0); } 
  virtual void stand(int which = 0)  { anim->playAction(STAND+which); }
  virtual void attack(int which = 0) { anim->playAction(ATTACK+which); }
  virtual void run(int which = 0)    { anim->playAction(RUN+which); }
  virtual void duck(int which = 0)   { anim->playAction(DUCK+which); }
  virtual void pain(int which = 0)   {
    anim->playAction(PAIN+which);
    anim->setInterrupt(); // interrupt any other action
  }

  virtual void walk(int which = 0)   { anim->playAction(WALK+which); }
  virtual void death(int which = 0) {
    anim->playAction(DEATH+which);
    anim->setStop();
    anim->setInterrupt();
  }
  virtual void fall(int which = 0) {
    anim->playAction(FALL+which);
    anim->setStop();
  }
};

#endif
