//====================================================================
//#
//#  CaveQuakeOpponent.h                              ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#ifndef CAVE_QUAKE_OPPONENT_H
#define CAVE_QUAKE_OPPONENT_H

#include "CaveQuakeMonster.h"

class CaveQuakeOpponent : public CaveQuakeMonster {

protected:

  pfDCS *gunDcs, *defGunDcs;
  md2Animation *gunAnim;
  int SALUTE, TAUNT;
  pfNode *grunt, *viper, *psycho, *ensign, *athena;
  pfNode *gun, *gunM[6], *gunF[6];
  int model, currGun;

public:

  CaveQuakeOpponent() : CaveQuakeMonster("players/male/grunt/tris.md2") {
    initActions();
    grunt = monster;
    viper = pfdLoadFile_md2("players/male/viper/tris.md2");
    psycho = pfdLoadFile_md2("players/male/psycho/tris.md2");
    ensign = pfdLoadFile_md2("players/female/ensign/tris.md2");
    athena = pfdLoadFile_md2("players/female/athena/tris.md2");
    initModelActions(md2GetNodeAnimation(viper));
    initModelActions(md2GetNodeAnimation(psycho));
    initModelActions(md2GetNodeAnimation(ensign));
    initModelActions(md2GetNodeAnimation(athena));

    //fprintf(stderr, "NUMBER OF ACTIONS: %d\n", anim->getNumActions());
    gunDcs = new pfDCS();
    gunDcs->setTrans(0.0f, 0.0f, 24.0f);

    gunM[0] = pfdLoadFile_md2("players/male/w_hyperblaster.md2");
    gunM[1] = pfdLoadFile_md2("players/male/w_glauncher.md2");
    gunM[2] = pfdLoadFile_md2("players/male/w_machinegun.md2");
    gunM[3] = pfdLoadFile_md2("players/male/w_rlauncher.md2");
    gunM[4] = pfdLoadFile_md2("players/male/w_shotgun.md2");
    gunM[5] = pfdLoadFile_md2("players/male/w_sshotgun.md2");
    initModelActions(md2GetNodeAnimation(gunM[0]));
    initModelActions(md2GetNodeAnimation(gunM[1]));
    initModelActions(md2GetNodeAnimation(gunM[2]));
    initModelActions(md2GetNodeAnimation(gunM[3]));
    initModelActions(md2GetNodeAnimation(gunM[4]));
    initModelActions(md2GetNodeAnimation(gunM[5]));

    gunF[0] = pfdLoadFile_md2("players/female/w_hyperblaster.md2");
    gunF[1] = pfdLoadFile_md2("players/female/w_glauncher.md2");
    gunF[2] = pfdLoadFile_md2("players/female/w_machinegun.md2");
    gunF[3] = pfdLoadFile_md2("players/female/w_rlauncher.md2");
    gunF[4] = pfdLoadFile_md2("players/female/w_shotgun.md2");
    gunF[5] = pfdLoadFile_md2("players/female/w_sshotgun.md2");
    initModelActions(md2GetNodeAnimation(gunF[0]));
    initModelActions(md2GetNodeAnimation(gunF[1]));
    initModelActions(md2GetNodeAnimation(gunF[2]));
    initModelActions(md2GetNodeAnimation(gunF[3]));
    initModelActions(md2GetNodeAnimation(gunF[4]));
    initModelActions(md2GetNodeAnimation(gunF[5]));

    model = 0;
    currGun = 2;
    gun = gunM[currGun];
    gunAnim = md2GetNodeAnimation(gun);
    gunDcs->addChild(gun);

    dcs->addChild(gunDcs);
  }

  int getModel() { return model; }
  void setModel(int which) {
    if (model == which) return;

    model = which;
    dcs->removeChild(monster);
    if (model == 0)
      monster = grunt;
    else if (model == 1)
      monster = viper;
    else if (model == 2)
      monster = ensign;
    else if (model == 3)
      monster = athena; 
    else if (model == 4)
      monster = psycho;
    else
      cout << "CaveQuakeOpponent::setModel() error!" << endl;
    dcs->addChild(monster);

    anim = md2GetNodeAnimation(monster);

    // need to reset gun (possible gender switch)
    int tmp = currGun;
    currGun = -1;
    setGunNum(tmp);
  }

  void switchModel() {
    int which = model + 1;
    int max = 3;
    //if (!strcmp(getenv("CAVE_QUAKE_NCSA"), "on")) 
      max = 4;
    if (which > max) which = 0;
    setModel(which);
  }

  void setGunNum(int which) {
    if (currGun == which) return;

    currGun = which;
    gunDcs->removeChild(gun);
    if (monster == grunt || monster == viper || monster == psycho) {
      gun = gunM[currGun];
      if (currGun == 3)
        gunDcs->setTrans(0.0f, 0.0f, 21.5f);
      else
        gunDcs->setTrans(0.0f, 0.0f, 24.0f);
    }
    else {
      gun = gunF[currGun]; 
      if (currGun == 3)
        gunDcs->setTrans(0.0f, 0.0f, 20.0f);
      else
        gunDcs->setTrans(0.0f, 0.0f, 22.0f);
    }
    gunDcs->addChild(gun);

    gunAnim = md2GetNodeAnimation(gun);

    anim->playAction(STAND);
    gunAnim->playAction(STAND);
    anim->setInterrupt();
    gunAnim->setInterrupt();
  }

  int getGunNum() { return currGun; }
  pfDCS *getGunDcs() { return gunDcs; }
  //pfSwitch *getGunSwitch() { return gunSwitch; }

  virtual void initActions() {
    STAND = anim->addAction(0, 39);
    RUN = anim->addAction(40, 45);
    WALK = anim->addAction(40, 45);
    ATTACK = anim->addAction(46, 53);
    anim->addAction(46, 48);
    //PAIN = anim->addAction(54, 65);
    PAIN = anim->addAction(61, 65);
    anim->addAction(61, 65);
    DEATH = anim->addAction(178, 184);
    //DEATH = anim->addAction(178, 197);
    SALUTE = anim->addAction(84, 94);
    TAUNT = anim->addAction(95, 111);
  }

  virtual void initModelActions(md2Animation *modelAnim) {
    modelAnim->addAction(0, 39);
    modelAnim->addAction(40, 45);
    modelAnim->addAction(40, 45);
    modelAnim->addAction(46, 53);
    modelAnim->addAction(46, 48);
    modelAnim->addAction(61, 65);
    modelAnim->addAction(61, 65);
    modelAnim->addAction(178, 184);
    modelAnim->addAction(84, 94);
    modelAnim->addAction(95, 111);
    modelAnim->playAction(STAND);
  }

   virtual void update() {
     CaveQuakeMonster::update();
     int frame = anim->getCurrFrame();
     if (frame != lastFrame && CAVEBUTTON2)
       cout << "frame: " << frame << endl;
     lastFrame = frame;
   }

  virtual void hit(int damage) {
    if (life <= 0) return;
    if (damage < 20)
      pain(1);
    else
      pain();
    // will be sent over to opponent (I hit you)
    //*damageOpp = damage;
    quakeSound("iPain", this->distanceFromEnemy());
  }

  virtual void death(int which=0) {
    if (anim->getCurrAction() != DEATH) {
      anim->playAction(DEATH);
      anim->setStop();
      anim->setInterrupt();
      gunAnim->playAction(DEATH);
      gunAnim->setStop();
      gunAnim->setInterrupt();
      quakeSound("iDeath", this->distanceFromEnemy());
    }
  }

  virtual void run(int which=0) {
    int currAction = anim->getCurrAction();
    if (currAction != RUN) {
      anim->playAction(RUN);
      gunAnim->playAction(RUN);
      if (currAction != ATTACK && currAction != ATTACK+1) {
        anim->setInterrupt();
        gunAnim->setInterrupt();
      }
    }
  }

  virtual void walk(int which=0) {
    int currAction = anim->getCurrAction();
    if (currAction != WALK) {
      anim->playAction(WALK);
      gunAnim->playAction(WALK);
      if (currAction != ATTACK && currAction != ATTACK+1) {
        anim->setInterrupt();
        gunAnim->setInterrupt();
      }
    }
  }

  virtual void stand(int which=0) {
    int currAction = anim->getCurrAction();
    if (currAction != STAND) {
      anim->playAction(STAND);
      gunAnim->playAction(STAND);
      if (currAction != ATTACK && currAction != ATTACK+1) {
        anim->setInterrupt();
        gunAnim->setInterrupt();
      }
    }
  }

  virtual void taunt() {
    int currAction = anim->getCurrAction();
    if (currAction != TAUNT) {
      anim->playAction(TAUNT);
      gunAnim->playAction(TAUNT);
      if (currAction != ATTACK && currAction != ATTACK+1) {
        anim->setInterrupt();
        gunAnim->setInterrupt();
      }
    }
  }
  
  virtual void salute() {
    int currAction = anim->getCurrAction();
    if (currAction != SALUTE) {
      anim->playAction(SALUTE);
      gunAnim->playAction(SALUTE);
      if (currAction != ATTACK && currAction != ATTACK+1) {
        anim->setInterrupt();
        gunAnim->setInterrupt();
      }
    }
  }

#if 0
  virtual void attack(float damage) {
    if (damage < 20) {
      quakeSound("iFire", this->distanceFromEnemy());
      if (anim->getCurrAction() != ATTACK+1) {
        anim->playAction(ATTACK+1);
        anim->setInterrupt();
        gunAnim->playAction(ATTACK+1);
        gunAnim->setInterrupt();
      }
    }
    else if (damage < 80) {
      quakeSound("sFire", this->distanceFromEnemy()); 
      if (anim->getCurrAction() != ATTACK) {
        anim->playAction(ATTACK);
        anim->setInterrupt();
        gunAnim->playAction(ATTACK);
        gunAnim->setInterrupt();
      }
    }
    else {
      quakeSound("pRGun", this->distanceFromEnemy());
      if (anim->getCurrAction() != ATTACK) {
        anim->playAction(ATTACK);
        anim->setInterrupt();
        gunAnim->playAction(ATTACK);
        gunAnim->setInterrupt();
      }
    }
  }
#endif

  virtual void fire() {
    // nothing... taken care of on other side.
  }
};

#endif
