//====================================================================
//#
//#  CaveQuakePlayer.cxx                               #####     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          ##
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                     #####
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999, 2000  Paul Rajlich, all rights reserved
//====================================================================

#include "CaveQuakePlayer.h"
#include "CaveQuakeBullet.h"

extern pfGeode *makePoster(char *filename);
extern float playerPlat[2];

void CaveQuakePlayer::reset() {
  life = 100;
  state = P_NORMAL;
  vSpeed = 0.0f;

  velX = 0.0f; velY = 0.0f; velZ = 0.0f; velM = 0.0f;

  str->setString("100");
  armorStr->setString("0");

  P = 0.0f;
  lastTime = 0.0f;
}

void CaveQuakePlayer::update(qkBsp *bsp) {
  float thisTime = pfGetTime();
  float elapsedTime = thisTime - lastTime;
  if (elapsedTime > 0.2f) // cap
    elapsedTime = 0.2f;  // bad things will happen otherwise :)
  char fpsVal[16];
  sprintf(fpsVal, "%.0f", 1.0/elapsedTime);
  fpsStr->setString(fpsVal);

  // "visual pain" experiment (red screen)
  if (painToggle && thisTime > painEndsTime) {
    pfGeode *playerGeom = (pfGeode *) headDcs->getChild(0);
    playerGeom->setTravMask(PFTRAV_DRAW, 0x0, PFTRAV_SELF, PF_SET);
  } 

  // wait until normal state (on ground) before dying
  if (life <= 0) { // && state == P_NORMAL) {
    if (state != P_DYING) {
      if (you->getModel() == 0 || you->getModel() == 1 || you->getModel() == 4)
        quakeSound("pDeath", 5.0f);
      else
        quakeSound("pDeathF", 5.0f);
      deathZ = Z;
    }
    state = P_DYING;
  }
  if (state == P_DYING) {
    if (P > -90.0f)
      P = P - 30.0f * elapsedTime; // faster than before (was 20.0f)

    if (side1HitD < 1.5f)
      Z += (1.5f - side1HitD);
    else if (side2HitD < 1.5f)
      Z += (1.5f - side2HitD); 
    else if (forwardHitD < 1.5f)
      Z += (1.5f - forwardHitD);
    else if (backwardHitD < 1.5f)
      Z += (1.5f - backwardHitD);

    if (Z > deathZ+8.0f)
      Z = deathZ+8.0f;

    lastTime = thisTime;
    return;
  }

//  cout << "elapsedTime: " << elapsedTime << endl;
//  cout << "XYZ: " << X << " " << Y << " " << Z << endl;

  float wandDir[3], wandPos[3], wandO[3], headPos[3];
  CAVEGetPosition (CAVE_HEAD, headPos);
  CAVEGetVector (CAVE_WAND_FRONT, wandDir);
  CAVEGetPosition (CAVE_WAND, wandPos);
  CAVEGetOrientation (CAVE_WAND, wandO);

  gunDcs->setRot(wandO[2]+90.0f, wandO[1], -wandO[0]);
  int gunVal = (int) gunSwitch->getVal();
  if (gunVal == 0) // hyper-blaster
    gunDcs->setTrans(wandPos[0], wandPos[1], wandPos[2]-1.4f); // was 1.0
  else
    gunDcs->setTrans(wandPos[0], wandPos[1], wandPos[2]-0.6f); // was 0.5

  pfMatrix rotM;
  rotM.makeRot(-H, 0.0f, 0.0f, 1.0f);

  // transform travel, side dirs to world coords.
  pfVec3 travelDir, side1Dir, side2Dir;
  if (joystickNav) {
    travelDir.xformPt(pfVec3(wandDir[0], wandDir[1], 0.0f), rotM);
    side1Dir.xformPt(pfVec3(-wandDir[1], wandDir[0], 0.0f), rotM);
    side2Dir.xformPt(pfVec3(wandDir[1], -wandDir[0], 0.0f), rotM);
  }
  else {
    travelDir.xformPt(pfVec3(0.0f, 1.0f, 0.0f), rotM);
    side1Dir.xformPt(pfVec3(-1.0f, 0.0f, 0.0f), rotM);
    side2Dir.xformPt(pfVec3(1.0f, 0.0f, 0.0f), rotM);
  }

  if (strafe && wandO[1] > 45.0f) {
    if (wandO[1] > 75.0f) wandO[1] = 75.0f;
    wandO[1] = wandO[1] - 35.0f;
    X += wandO[1] * 18.0f/40.0f * side2Dir[0] * elapsedTime;
    Y += wandO[1] * 18.0f/40.0f * side2Dir[1] * elapsedTime;
  }
  if (strafe && wandO[1] < -45.0f) {
    wandO[1] = fabsf(wandO[1]);
    if (wandO[1] > 75.0f) wandO[1] = 75.0f;
    wandO[1] = wandO[1] - 35.0f;
    X += wandO[1] * 18.0f/40.0f * side1Dir[0] * elapsedTime;
    Y += wandO[1] * 18.0f/40.0f * side1Dir[1] * elapsedTime;
  }

  if (joystickNav) {
    if (fabsf(CAVE_JOYSTICK_X) > 0.3f) // rotate by joystick
      H += CAVE_JOYSTICK_X*fabsf(CAVE_JOYSTICK_X)* 2.0 * rotSpeed * elapsedTime;
  } // rotate by wand orientation
  else if (fabsf(wandDir[0]) > 0.3f && fabsf(CAVE_JOYSTICK_Y) > 0.2f)
    H += wandDir[0] * fabsf(wandDir[0]) * 2.0 * rotSpeed * elapsedTime;

  if (fabsf(CAVE_JOYSTICK_Y) > 0.2f) {
    float d = transSpeed*CAVE_JOYSTICK_Y*fabsf(CAVE_JOYSTICK_Y)*elapsedTime;
    if (!CAVEBUTTON2 && d > 0.0f && d > forwardHitD - 2.0f)
      d = forwardHitD - 2.0f;
    if (!CAVEBUTTON2 && d < 0.0f && -d > backwardHitD - 2.0f)
      d = -(backwardHitD - 2.0f);
    X += d*travelDir[0];
    Y += d*travelDir[1];
  }

  if (noJoystick) {
    if (fabsf(wandDir[0]) > 0.3f)
      H += wandDir[0] * fabsf(wandDir[0]) * 2.0 * rotSpeed * elapsedTime;
    pfVec3 headXYPos(headPos[0], headPos[1], 0.0f);
    pfVec3 wandXYPos(wandPos[0], wandPos[1], 0.0f);
    float d = wandXYPos.distance(headXYPos);
    if (d > 1.2f) {
      if (d > 2.4f) d = 2.4f;
      d = (d - 1.2f)/1.2f;
      d = d * transSpeed*elapsedTime;
      if (!CAVEBUTTON2 && d > 0.0f && d > forwardHitD - 2.0f)
        d = forwardHitD - 2.0f;
      if (!CAVEBUTTON2 && d < 0.0f && -d > backwardHitD - 2.0f)
        d = -(backwardHitD - 2.0f);
      X += d*travelDir[0];
      Y += d*travelDir[1];
    }
  }

  // prevent physically going through things
  if (!CAVEBUTTON2) {
    if (forwardHitD < 1.5f) {
      X -= (1.5f - forwardHitD)*travelDir[0];
      Y -= (1.5f - forwardHitD)*travelDir[1];
    }
    if (backwardHitD < 1.5f) {
      X += (1.5f - backwardHitD)*travelDir[0];
      Y += (1.5f - backwardHitD)*travelDir[1];
    }
    if (side1HitD < 1.5f) {
      X -= (1.5f - side1HitD)*side1Dir[0];
      Y -= (1.5f - side1HitD)*side1Dir[1];
    }
    if (side2HitD < 1.5f) {
      X -= (1.5f - side2HitD)*side2Dir[0];
      Y -= (1.5f - side2HitD)*side2Dir[1]; 
    }
  }

  if (CAVEButtonChange(2) == 1) {
    switchGun();
    //setVel(0.0f, 0.0f, 1.0f, 40.0f); // jump
  }

  // velocity magnitude decreases at gravity rate
  if (velM > 0.0f)
    velM -= P_GRAVITY * elapsedTime;
  else
    velM = 0.0f;

  // berserk hit!
  //if (velM > 0.0f && fabsf(backwardHitD) > 5.0f && fabsf(forwardHitD) > 5.0f 
  //    && fabsf(side1HitD) > 5.0f && fabsf(side2HitD) > 5.0f) {
  if (velM > 0.0f) {
    X += velX*velM * elapsedTime;
    Y += velY*velM * elapsedTime;
  }

  if (CAVEgetbutton(CAVE_ZKEY))
    state = P_RISING;

  if (state == P_FALLING)
    vSpeed -= P_GRAVITY * elapsedTime;
  else if (state == P_RISING)
    vSpeed += P_GRAVITY * elapsedTime;    

  Z += (vSpeed+velZ*velM) * elapsedTime;

  // find location in real world
  pfVec3 headWorldPos;
  headWorldPos.xformPt(pfVec3(headPos[0], headPos[1], headPos[2]), rotM);

  if (!CAVEBUTTON2) {
    float newPos[3];
    float newPosScale[3];
    newPos[0] = X + headWorldPos[0];
    newPos[1] = Y + headWorldPos[1];
    newPos[2] = Z + headWorldPos[2];
    newPosScale[0] = newPos[0]*10.0f;
    newPosScale[1] = newPos[1]*10.0f;
    newPosScale[2] = newPos[2]*10.0f;
    // if new head location is negative cluster, restore old head position
    // note: this is not the same as restoring the old CAVE position
    if (qkFindCurCluster(newPosScale, bsp) == -1) {
      X += (storePos[0] - newPos[0]);
      Y += (storePos[1] - newPos[1]);
      Z += (storePos[2] - newPos[2]);
      vSpeed = 0.0f;
      state = P_NORMAL;
    }
    storePos[0] = X + headWorldPos[0];
    storePos[1] = Y + headWorldPos[1];
    storePos[2] = Z + headWorldPos[2];
  }
  
  // update block around player
  headDcs->setTrans(storePos[0], storePos[1], storePos[2] + 0.5f);

  lastTime = thisTime;
}

void CaveQuakePlayer::isect(pfDCS *top) {
  static float time = 0.0f;
  //if (pfGetTime() < lastTime) return; // pause
  pfHit **hits[32];
  int isect;
  
  float headPos[3], wandDir[3], wandPos[3];
  CAVEGetPosition (CAVE_HEAD, headPos);
  CAVEGetVector (CAVE_WAND_FRONT, wandDir);
  CAVEGetPosition (CAVE_WAND, wandPos);

  segset.segs[0].pos.set(headPos[0], headPos[1], headPos[2]); // down from head
  segset.segs[1].pos.set(headPos[0], headPos[1], headPos[2]); // forward
  segset.segs[2].pos.set(headPos[0], headPos[1], headPos[2]); // backward
  segset.segs[3].pos.set(headPos[0], headPos[1], headPos[2]); // side1
  segset.segs[4].pos.set(headPos[0], headPos[1], headPos[2]); // side2

  if (joystickNav) {
    segset.segs[0].dir.set(0.0f, 0.0f, -1.0f);              // down
    segset.segs[1].dir.set(wandDir[0], wandDir[1], 0.0f);   // forward
    segset.segs[2].dir.set(-wandDir[0], -wandDir[1], 0.0f); // backward
    segset.segs[3].dir.set(-wandDir[1], wandDir[0], 0.0f);  // side1
    segset.segs[4].dir.set(wandDir[1], -wandDir[0], 0.0f);  // side2
  }
  else {
    segset.segs[0].dir.set(0.0f, 0.0f, -1.0f);
    segset.segs[1].dir.set(0.0f, 1.0f, 0.0f);
    segset.segs[2].dir.set(0.0f, -1.0f, 0.0f);
    segset.segs[3].dir.set(-1.0f, 0.0f, 0.0f);
    segset.segs[4].dir.set(1.0f, 0.0f, 0.0f); 
  }

  // gun fire seg
  //segset.activeMask = 63;
  //segset.segs[5].dir.set(wandDir[0], wandDir[1], wandDir[2]);
  //segset.segs[5].pos.set(wandPos[0], wandPos[1], wandPos[2]);

  // PAUL!
  segset.activeMask = 31;
  //segset.activeMask = 1;  // just down

  isect = top->isect(&segset, hits);

  if (isect) {
    pfVec3 pnt, xpnt;
    pfMatrix xmat;

    if (state != P_DYING) {
      (*hits[0])->query(PFQHIT_POINT, pnt.vec);
      (*hits[0])->query(PFQHIT_XFORM, (float*)xmat.mat);
      xpnt.xformPt(pnt, xmat);
      // on a platform, and we need to rise...
      if (playerPlat[0] && xpnt[PF_Z] > 0.0f) {
        state = P_NORMAL;
        vSpeed = 0.0f;
        Z += xpnt[PF_Z];
      }
      else if (xpnt[PF_Z] > 0.3f) {
        state = P_RISING;
        if (vSpeed < 0.0f) vSpeed = 0.0f; // floor stopped the speed
      }
      else if (xpnt[PF_Z] < -0.3f) {
        state = P_FALLING;
        if (vSpeed > 0.0f) vSpeed = 0.0f; 
      }
      else {
        state = P_NORMAL;
        if (vSpeed < -12.0f) {
          if (you->getModel() == 0 || you->getModel() == 1 || you->getModel() == 4)
            quakeSound("pFall", 10.0f);
          else
            quakeSound("pFallF", 10.0f);
        }
        vSpeed = 0.0f;
      }
    }

    (*hits[1])->query(PFQHIT_POINT, pnt.vec);
    (*hits[1])->query(PFQHIT_XFORM, (float*)xmat.mat);
    xpnt.xformPt(pnt, xmat);
    if ((xpnt[PF_X] != 0) || (xpnt[PF_Y] != 0)) 
      forwardHitD = xpnt.distance(pfVec3(headPos[0], headPos[1], headPos[2]));
   
    (*hits[2])->query(PFQHIT_POINT, pnt.vec);
    (*hits[2])->query(PFQHIT_XFORM, (float*)xmat.mat);
    xpnt.xformPt(pnt, xmat);
    if ((xpnt[PF_X] != 0) || (xpnt[PF_Y] != 0))
      backwardHitD = xpnt.distance(pfVec3(headPos[0], headPos[1], headPos[2]));

    (*hits[3])->query(PFQHIT_POINT, pnt.vec);
    (*hits[3])->query(PFQHIT_XFORM, (float*)xmat.mat);
    xpnt.xformPt(pnt, xmat);
    if ((xpnt[PF_X]) != 0 || (xpnt[PF_Y] != 0))
      side1HitD = xpnt.distance(pfVec3(headPos[0], headPos[1], headPos[2]));

    (*hits[4])->query(PFQHIT_POINT, pnt.vec);
    (*hits[4])->query(PFQHIT_XFORM, (float*)xmat.mat);
    xpnt.xformPt(pnt, xmat);
    if ((xpnt[PF_X]) != 0 || (xpnt[PF_Y] != 0))
      side2HitD = xpnt.distance(pfVec3(headPos[0], headPos[1], headPos[2]));

  } // isect

  // bullets
  if (CAVEBUTTON1 && state != P_DYING) {

    int gunVal = (int) gunSwitch->getVal();
    if (gunVal == 1 || gunVal == 4) return;
    if (gunVal == 0 && pfGetTime() < time+0.2f) return; // was 0.3
    if (gunVal == 2 && pfGetTime() < time+0.1f) return;
    if (gunVal == 3 && pfGetTime() < time+1.1f) return;
    if (gunVal == 5 && pfGetTime() < time+1.2f) return;
    time = pfGetTime();

    pfMatrix rotM;
    rotM.makeRot(-H, 0.0f, 0.0f, 1.0f);

    pfVec3 bPos, bDir;
    bPos.xformPt(pfVec3(wandPos[0], wandPos[1], wandPos[2]), rotM);
    bDir.xformPt(pfVec3(wandDir[0], wandDir[1], wandDir[2]), rotM);
    bPos[0] += X; bPos[1] += Y; bPos[2] += Z+0.5f;
    if (gunVal == 3)
      bPos += bDir * 4.0f;
    else
      bPos += bDir * 2.5f;
    //cout << "bPos: " << bPos[0] << " " << bPos[1] << " " << bPos[2] << endl;
    //cout << "bDir: " << bDir[0] << " " << bDir[1] << " " << bDir[2] << endl;

    CaveQuakeBullet *b;
    if (gunVal == 0) {
      //quakeSound("pLGun", 5.0f);
      quakeSound("pLGun", 7.0f);
      b = new CaveQuakeBullet(bPos, bDir, bullet, explosion, 100.0f, 15, 0.3f, "pLGunX"); // was 80.0f, 15
      b->playerIsect();
    }
    if (gunVal == 2) {
      int which = rand()%6;
      if (which == 0) quakeSound("pMGun1a", 5.0f);
      if (which == 1) quakeSound("pMGun2a", 5.0f);
      if (which == 2) quakeSound("pMGun3a", 5.0f);
      b = new CaveQuakeBullet(bPos, bDir, new pfGroup, explosion, 500.0f, 5, 0.05f);
      b->playerIsect();
    }
    if (gunVal == 3) {
      quakeSound("pRGun", 4.0f);
      b = new CaveQuakeBullet(bPos, bDir, rocket, explodeDcs, 55.0f, 120, 0.5f, "pRGunX"); // was 40.0f, 120
      b->playerIsect();
    }
    if (gunVal == 5) {
      quakeSound("pSGun", 5.0f);
      b = new CaveQuakeBullet(bPos, bDir, new pfGroup, smoke, 500.0f, 40, 0.05f);
      b->playerIsect();
    }
    b->getRoot()->setTravFuncs(PFTRAV_APP, NULL, updateBulletFunc);
    b->getRoot()->setTravData(PFTRAV_APP, b);
    transDcs->addChild(b->getRoot()); // transDcs is extern (caveQuake.cxx)
  }
}

void CaveQuakePlayer::makeStats() {
  //pfGeoState *gstate;
  statsDcs = new pfDCS;
  statsDcs->setScale(0.6f, 0.6f, 0.6f);
  //statsDcs->setTrans(4.3f, 5.0f, 8.0f);
  statsDcs->setTrans(4.3f, 5.0f, 7.2f);

  pfText *text = new pfText;
  pfFont *fnt = pfdLoadFont_type1("Times-Elfin",PFDFONT_FILLED);
  str = new pfString;
  str->setFont(fnt);
  str->setColor(0.8f, 0.8f, 0.8f, 1.0f);
  str->setMode(PFSTR_JUSTIFY, PFSTR_RIGHT);
  str->setString("100");
  str->flatten();
  text->addString(str);

  pfText *armorText = new pfText;
  armorStr = new pfString;
  armorStr->setFont(fnt);
  armorStr->setColor(0.8f, 0.8f, 0.8f, 1.0f);
  armorStr->setMode(PFSTR_JUSTIFY, PFSTR_RIGHT);
  armorStr->setString("0");
  armorStr->flatten();
  armorText->addString(armorStr);
  pfDCS *armorTextDcs = new pfDCS;
  armorTextDcs->setTrans(0.0f, 0.0f, -0.8f);
  armorTextDcs->addChild(armorText);

  pfDCS *armorDcs = new pfDCS;
  armorDcs->setScale(0.06f, 0.06f, 0.06f);
  armorDcs->setTrans(0.4f, 0.0f, -.55f);
  armorDcs->addChild(makePoster("imgs/i_armor.rgb"));
  statsDcs->addChild(armorDcs);

  pfDCS *healthDcs = new pfDCS;
  healthDcs->setScale(0.06f, 0.06f, 0.06f);
  healthDcs->setTrans(0.4f, 0.0f, 0.25f);
  healthDcs->addChild(makePoster("imgs/i_health.rgb"));
  statsDcs->addChild(healthDcs);

  pfDCS *frameDcs = new pfDCS;
  frameDcs->setScale(0.06f, 0.06f, 0.06f);
  frameDcs->setTrans(0.4f, 0.0f, 1.05f);
  frameDcs->addChild(makePoster("imgs/i_fps.rgb"));
  statsDcs->addChild(frameDcs);

  //gstate = new pfGeoState;
  //gstate->setMode(PFSTATE_ENLIGHTING, PF_OFF);
  //str->setGState(gstate);

  // wait until after skull... see if this fixes problem (no texture)
  //statsDcs->addChild(text);

  statsDcs->addChild(text);
  statsDcs->addChild(armorTextDcs);

  pfDCS *fpsDcs = new pfDCS;
  fpsDcs->setTrans(0.0f, 0.0f, 0.8f);
  
  pfText *text2 = new pfText;
  fpsStr = new pfString;
  fpsStr->setFont(fnt);
  fpsStr->setColor(0.8f, 0.8f, 0.8f, 1.0f);
  fpsStr->setMode(PFSTR_JUSTIFY, PFSTR_RIGHT);
  fpsStr->setString("10");
  fpsStr->flatten();
  text2->addString(fpsStr);

  fpsDcs->addChild(text2);
  statsDcs->addChild(fpsDcs);

  pfDCS *mesgDcs = new pfDCS;
//  mesgDcs->setScale(0.5f, 0.5f, 0.5f);
  mesgDcs->setTrans(0.0f, 0.0f, 1.6f);

  pfText *mesg = new pfText;
  mesgStr = new pfString;
  mesgStr->setFont(fnt);
  mesgStr->setColor(0.5f, 0.8f, 0.5f, 1.0f);
  mesgStr->setMode(PFSTR_JUSTIFY, PFSTR_RIGHT);
  mesgStr->setString("--");
  mesgStr->flatten();
  mesg->addString(mesgStr);

  mesgDcs->addChild(mesg);
  statsDcs->addChild(mesgDcs);
}

static int gstatePreApply(pfGeoState *gst, void *data)
{
  // blend explain - do not multiply source by factor. Just take dest
  //   (what is in frame buffer) and factor by src.
  //glBlendFunc(GL_ZERO, GL_SRC_COLOR);
  glBlendFunc(GL_SRC_ALPHA, GL_SRC_ALPHA);
  glDepthFunc(GL_LEQUAL);
  return 0;
}

pfNode *CaveQuakePlayer::makeGeom() {

  headDcs = new pfDCS;
  headDcs->setTrans(0.0f, 0.0f, 6.0f);

  pfGeode *geom = new pfGeode;
  geom->setName("player");
  
  int nVertices = 8;
  pfVec3 *v = (pfVec3 *) pfMalloc(nVertices*sizeof(pfVec3), pfGetSharedArena());
  v[0].set(-1.3f, -1.3f, 0.0f);
  v[1].set(-1.3f, 1.3f, 0.0f);
  v[2].set(1.3f, 1.3f, 0.0f);
  v[3].set(1.3f, -1.3f, 0.0f);

  v[4].set(-1.3f, -1.3f, -6.0f);
  v[5].set(-1.3f, 1.3f, -6.0f);
  v[6].set(1.3f, 1.3f, -6.0f);
  v[7].set(1.3f, -1.3f, -6.0f);

  int *lengths = (int *) pfMalloc(6*sizeof(int), pfGetSharedArena());
  for (int i=0; i<6; i++)
    lengths[i] = 4;

  ushort *vindex = (ushort *) pfMalloc(24*sizeof(ushort), pfGetSharedArena());
  vindex[0] = 6; vindex[1] = 5; vindex[2] = 1; vindex[3] = 2;
  vindex[4] = 5; vindex[5] = 4; vindex[6] = 0; vindex[7] = 1;
  vindex[8] = 3; vindex[9] = 0; vindex[10] = 4; vindex[11] = 7;
  vindex[12] = 2; vindex[13] = 3; vindex[14] = 7; vindex[15] = 6;

  vindex[16] = 0; vindex[17] = 1; vindex[18] = 2; vindex[19] = 3;
  vindex[20] = 7; vindex[21] = 6; vindex[22] = 5; vindex[23] = 4;

  pfGeoSet *gset = new pfGeoSet;
  gset->setPrimType(PFGS_POLYS);
  gset->setNumPrims(6);
  gset->setPrimLengths(lengths);
  gset->setAttr(PFGS_COORD3, PFGS_PER_VERTEX, v, vindex);

  pfVec4 *color = (pfVec4 *) pfMalloc(sizeof(pfVec4), pfGetSharedArena());
  //float r = atof(getenv("CQ_R"));
  //float g = atof(getenv("CQ_G"));
  //float b = atof(getenv("CQ_B"));
  //float a = atof(getenv("CQ_A"));
  //color->set(r, g, b, a); 
  color->set(1.0f, 0.7f, 0.7f, 0.4f);
  ushort *cindex = (ushort *) pfMalloc(sizeof(ushort), pfGetSharedArena());
  cindex[0] = 0;
  gset->setAttr(PFGS_COLOR4, PFGS_OVERALL, color, cindex);
  //gset->setDrawBin(2);
  gset->setDrawBin(PFSORT_TRANSP_BIN);

  pfGeoState *gstate = new pfGeoState;
  gstate->setMode(PFSTATE_ENLIGHTING, PF_OFF);
  gstate->setMode(PFSTATE_TRANSPARENCY, PFTR_BLEND_ALPHA);
  gstate->setMode(PFSTATE_CULLFACE, PFCF_OFF);
  //gstate->setFuncs(gstatePreApply, NULL, NULL);

  gset->setGState(gstate);
  geom->addGSet(gset);
  headDcs->addChild(geom);

  // player will not isect against this geometry... monsters, bullets will
  geom->setTravMask(PFTRAV_ISECT, 0x0001, PFTRAV_SELF, PF_SET);
  geom->setTravMask(PFTRAV_DRAW, 0x0, PFTRAV_SELF, PF_SET); // do not draw
  geom->setTravData(PFTRAV_APP, this);

  return headDcs;
}
