//====================================================================
//#
//#  CaveQuakePlayer.h                                ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#ifndef CAVE_QUAKE_PLAYER_H
#define CAVE_QUAKE_PLAYER_H

#ifdef USE_CAVELIB
#include <pfcave.h>
#else
#include "pfcaveAlt.h"
#endif
#include <Performer/pfdu.h>
#include <Performer/pf/pfDCS.h>
#include <Performer/pf/pfSwitch.h>
#include <Performer/pf/pfTraverser.h>
#include <Performer/pf/pfGeode.h>
#include <Performer/pf/pfText.h>
#include <Performer/pr/pfGeoSet.h>
#include <Performer/pr/pfString.h>
#include <iostream.h>
#include "pfmd2.h"
#include "pfbsp.h"
#include "defs.h"
#include "utils.h"
#include "CaveQuakeBeing.h"
#include "CaveQuakeOpponent.h"

#define P_NORMAL 0
#define P_FALLING 1
#define P_RISING 2
#define P_DYING 3
#define P_GRAVITY 16.0f

extern CaveQuakeOpponent *you;

class CaveQuakePlayer : public CaveQuakeBeing {

protected:
  float rotSpeed, transSpeed, rotFactor;
  pfSegSet segset;
  float forwardHitD, backwardHitD, side1HitD, side2HitD;
  int state;
  float vSpeed;
  float velX, velY, velZ, velM;
  pfDCS *gunDcs, *explodeDcs, *headDcs, *statsDcs;
  pfSwitch *gunSwitch;
  pfNode *explosion, *smoke, *explode, *bullet, *rocket;
  pfString *str, *armorStr, *fpsStr, *mesgStr;
  int joystickNav, strafe, noJoystick;
  float deathZ; // save death Z val
  int armor;
  float storePos[3];

public:
  float lastTime, painEndsTime, painToggle; // :)

  CaveQuakePlayer() {

    state = P_NORMAL;
    vSpeed = 0.0;

    rotSpeed = 40.0;
    transSpeed = 24.0;

    forwardHitD = 10.0;
    backwardHitD = 1.0;
    side1HitD = 3.0;
    side2HitD = 3.0;

    // set up intersection segments
    segset.activeMask = 63; // which segs are active (bits)
    //segset.isectMask = 0xFFFF;
    segset.isectMask = 0xFFF0; // do not isect with self
    //segset.isectMask = PFBSP_ISECT_MASK_SOLID;
    segset.discFunc = NULL;
    segset.bound = NULL;
    segset.mode = PFTRAV_IS_PRIM|PFTRAV_IS_NORM|PFTRAV_IS_PATH;

    for (int i=0; i<6; i++)
     segset.segs[i].length = 500.0f;

    gunDcs = new pfDCS();
    gunDcs->setScale(0.08f, 0.08f, 0.08f);
    gunDcs->setRot(90.0f, 0.0f, 0.0f);
    gunDcs->setTrans(0.0f, 0.0f, 4.0f);

    pfNode *guns[6];
    //guns[0] = pfdLoadFile_md2("models/weapons/g_blast/tris.md2");
    guns[0] = pfdLoadFile_md2("models/weapons/g_hyperb/tris.md2");
    guns[1] = pfdLoadFile_md2("models/weapons/g_launch/tris.md2");
    guns[2] = pfdLoadFile_md2("models/weapons/g_machn/tris.md2");
    guns[3] = pfdLoadFile_md2("models/weapons/g_rocket/tris.md2");
    guns[4] = pfdLoadFile_md2("models/weapons/g_shotg/tris.md2");
    guns[5] = pfdLoadFile_md2("models/weapons/g_shotg2/tris.md2");
    gunSwitch = new pfSwitch();
    for (int j=0; j<6; j++)
      gunSwitch->addChild(guns[j]);
    //gunSwitch->setVal(2); // machine gun
    gunSwitch->setVal(0); // hyper blaster
    gunDcs->addChild(gunSwitch);

    explodeDcs = new pfDCS();
    //explodeDcs->setScale(0.1f, 0.1f, 0.1f);
    explodeDcs->setScale(5.0f, 5.0f, 5.0f);
    explode = pfdLoadFile_md2("models/objects/explode/tris.md2");
    pfDCS *smokeDcs = new pfDCS();
    smokeDcs->setScale(3.0f, 3.0f, 3.0f);
    smokeDcs->addChild(pfdLoadFile_md2("models/objects/smoke/tris.md2"));
    smoke = (pfNode *) smokeDcs;
    explosion = explode; // machine gun...
    explodeDcs->addChild(explode);

    bullet = pfdLoadFile_md2("models/objects/laser/tris.md2");
    rocket = pfdLoadFile_md2("models/objects/rocket/tris.md2");
  
    joystickNav = 0;
    noJoystick = 0;
    strafe = 1;
    lastTime = 0.0f;
  
    rotFactor = 1.0f; 
    makeStats();
  
    armor = 0;

    painToggle = 1; // visual pain is on
    painEndsTime = 0.0f;
  }

  void setVel(float x, float y, float z, float m) {
    velX = x; velY = y; velZ = z; velM = m;
  }
  pfDCS *getExplodeDcs() { return explodeDcs; }
  pfDCS *getGunDcs() { return gunDcs; }
  void setRotSpeed(float val) { rotSpeed = val; }
  void setTransSpeed(float val) { transSpeed = val; } 
  float getRotSpeed() { return rotSpeed; }
  float getTransSpeed() { return transSpeed; }
  void setJoystickNav(int i=1) { joystickNav = i; }
  void setStrafe(int i=1) { strafe = i; }
  void setNoJoystick(int i=1) { noJoystick = i; }
  void setPainToggle(int i=0) { painToggle = i; }

  pfSwitch *getGunSwitch() { return gunSwitch; }
  void switchGun() {
    int i = (int) gunSwitch->getVal();
    i++;
    if (i == 1) i++; // grenade launcher
    if (i == 2) i++; // machine gun
    if (i == 4) i++; // shotgun
    if (i == 5) i++; // super shotgun
    if (i > 5) i=0;
    gunSwitch->setVal(i);
    you->setGunNum(i);
  }

  void update(qkBsp *bsp);
  void isect(pfDCS *top);
  pfNode *makeGeom();
  void reset();
  virtual void setArmor(int amt) { armor = amt; }
  virtual int getArmor() { return armor; }
  virtual void hit(int damage) {
    int armorDamage = (int) (damage*0.6f);
    if (armorDamage < armor) {
      armor -= armorDamage;
      damage -= armorDamage;
    }
    else {
      damage -= armor;
      armor = 0;
    }
    life -= damage;
    if (life < 0) life = 0;
    char lifeVal[64], armorVal[64];
    sprintf(lifeVal, "%d", life);
    sprintf(armorVal, "%d", armor);
    str->setString(lifeVal);
    armorStr->setString(armorVal);
    if (life > 0) {
      if (damage >= 15) {
        if (you->getModel() == 0 || you->getModel() == 1 || you->getModel() == 4)
          quakeSound("pBigPain", 8.0f);
        else
          quakeSound("pBigPainF", 8.0f);
        painEndsTime = pfGetTime()+0.8f;
      }
      else {
        if (you->getModel() == 0 || you->getModel() == 1 || you->getModel() == 4)
          quakeSound("pPain", 15.0f); 
        else
          quakeSound("pPainF", 15.0f); 
        painEndsTime = pfGetTime()+0.4f;
      }
    }
    if (painToggle) {
      pfGeode *playerGeom = (pfGeode *) headDcs->getChild(0);
      playerGeom->setTravMask(PFTRAV_DRAW, 0xFFFFFFFF, PFTRAV_SELF, PF_SET);
    }
  }
  void makeStats();
  pfNode *getStatsDcs() { return statsDcs; }
  pfString *getStr() { return str; }
  pfString *getArmorStr() { return armorStr; }
  pfString *getMesgStr() { return mesgStr; }
};

#endif
