//====================================================================
//#
//#  CaveQuakeSoldier.h                               ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#ifndef CAVE_QUAKE_SOLDIER_H
#define CAVE_QUAKE_SOLDIER_H

#include "CaveQuakeMonster.h"
#include "CaveQuakeBullet.h"

extern pfNode *laser;

class CaveQuakeSoldier : public CaveQuakeMonster {

public:

  CaveQuakeSoldier() : CaveQuakeMonster("models/monsters/soldier/tris.md2") {
    initActions();
    //fprintf(stderr, "NUMBER OF ACTIONS: %d\n", anim->getNumActions());
    //WALKSPEED = 2.0;
    //RUNSPEED = 5.0;
    WALKSPEED = 2.0*7.0/5.0;
    RUNSPEED = 5.0*7.0/5.0;
    life = 40;
    lastFrame = 0;
  }
  
  virtual void reset() {
    CaveQuakeMonster::reset();
    life = 40;
  }

  virtual void initActions() {
    STAND = anim->addAction(164, 284);
    //STAND = anim->addAction(164, 166);
    WALK = anim->addAction(285, 341);
    //RUN = anim->addAction(115, 126); // attacking run
    RUN = anim->addAction(127, 144);   // regular run
    //PAIN = anim->addAction(68, 114);
    PAIN = anim->addAction(68, 71);
    anim->addAction(79, 98);
    anim->addAction(72, 78);
    DUCK = anim->addAction(63, 67);
    DEATH = anim->addAction(30, 47);
    anim->addAction(54, 62);
    anim->addAction(48, 53);
    ATTACK = anim->addAction(0, 29);
    anim->addAction(0, 29);
    //anim->addAction(145, 163);
  }

  virtual void update() {
    int frame = anim->getCurrFrame();
    if (frame != lastFrame) {
      //if (CAVEBUTTON2)
      //  cout << "frame: " << frame << endl;

      // sounds
      if (frame == 3)
        quakeSound("sFire", this->distanceFromEnemy());
      else if (frame == 16 || frame == 124 || frame == 40)
        quakeSound("sFire2", this->distanceFromEnemy());
      else if (frame == 69) 
        quakeSound("sPain2", this->distanceFromEnemy());
      else if (frame == 81)
        quakeSound("sPain1", this->distanceFromEnemy());
      else if (frame == 31)
        quakeSound("sDeath1", this->distanceFromEnemy());
      else if (frame == 54)
        quakeSound("sDeath3", this->distanceFromEnemy());
      else if (frame == 166 || frame == 196 || frame == 226 || frame == 256) {
        int doit = rand()%5;
        if (doit == 2)
          quakeSound("sSearch", this->distanceFromEnemy()+5.0f);
        else if (doit == 3)
          quakeSound("sIdle", this->distanceFromEnemy()+10.0f);
      }

      // damage
      //if (frame == 18 || frame == 125 || frame == 42)
      if (frame == 16 || frame == 123)
        fire(3);
      else if (frame == 40)
        fire(3, 1);
      else if (frame == 3)
        fire(6);
      //else if (frame == 115 && lastFrame == 124)
      else if (frame == 113 && lastFrame == 122)
        fire(3);
   
      // speeds
      if (frame >=0 && frame <= 53) setSpeed(0.0);
      else if (frame >= 54 && frame <= 58) setSpeed(-122+frame*2);
      else if (frame >= 59 && frame <= 114) setSpeed(0.0);
      else if (frame >= 115 && frame <= 123) setSpeed(RUNSPEED);
      else if (frame >= 124 && frame <= 126) setSpeed(0.0);
      else if (frame >= 127 && frame <= 144) setSpeed(RUNSPEED);
      else if (frame >= 145 && frame <= 284) setSpeed(0.0);
      else if (frame >= 285 && frame <= 295) setSpeed(WALKSPEED);
      else if (frame >= 296 && frame <= 322) setSpeed(0.0);
      else if (frame >= 323) setSpeed(WALKSPEED);
    }
    lastFrame = frame;

    CaveQuakeMonster::update();
  }

  virtual void fire(int damage, int which=0) {
    if (damage < 5) {
      CaveQuakeBullet *b;
      pfMatrix rotM;
      rotM.makeRot(H, 0.0f, 0.0f, 1.0f);
      pfVec3 gunPos; 
      if (which == 0)
        gunPos.xformPt(pfVec3(2.8f, -1.2f, 4.6f), rotM);  // pos of gun
      else 
        gunPos.xformPt(pfVec3(1.6f, 0.0f, 2.5f), rotM);  // pos of gun
      pfVec3 bulletPos(X, Y, Z);
      bulletPos += gunPos;
      if (inSight() && enemy != NULL) {
        pfVec3 enemyPos(enemy->X, enemy->Y, enemy->Z+4.0f);
        pfVec3 dir = enemyPos - bulletPos;
        dir.normalize();
        b = new CaveQuakeBullet(bulletPos, dir, laser, new pfGroup, 40.0f, 4, 0.3f);
      }
      else {
        pfVec3 dir(dx, dy, 0.0f);
        b = new CaveQuakeBullet(bulletPos, dir, laser, new pfGroup, 40.0f, 4, 0.3f);
      }
      b->getRoot()->setTravFuncs(PFTRAV_APP, NULL, updateBulletFunc);
      b->getRoot()->setTravData(PFTRAV_APP, b);
      transDcs->addChild(b->getRoot()); // transDcs is extern (caveQuake.cxx)
    }
    else
    if (inSight())
      enemy->hit(damage);
  }

  virtual void sight() {
    if (mood == M_FRIENDLY) {
      quakeSound("sSight", this->distanceFromEnemy());
      run();
      anim->setInterrupt();
    }
    CaveQuakeMonster::sight();
  }

  virtual void ai() {
    CaveQuakeMonster::ai();

    if (life <= 0) return;
    //if (distanceFromEnemy() <= 15.0f)
    //  attack();
    if (mood == M_ANGRY || distanceFromEnemy() <= 15.0f)
      attack();
    else if (mood == M_ANGRY_RAND)
      run();
  }

  virtual void hit(int damage) {
    if (mood == M_DEAD) return;
    CaveQuakeMonster::hit(damage);
    if (damage > 20 && life <= 0 && anim->getCurrAction() != DEATH+1)
      death(1);
  }
};

#endif
