//====================================================================
//#
//#  CaveQuakeTank.h                                  ##   ##     
//#                                                   ##   ##
//#  Author(s): Paul Rajlich                          #######
//#  Email: prajlich@ncsa.uiuc.ed                     ##   ##
//#  Date created:                                    ##   ##
//#
//#  Description: CAVE QUAKE II
//#
//====================================================================
//#  (c)opyright 1998, 1999  Paul Rajlich, all rights reserved
//====================================================================

#ifndef CAVE_QUAKE_TANK_H
#define CAVE_QUAKE_TANK_H

#include "CaveQuakeMonster.h"
#include "CaveQuakeBullet.h"

extern pfNode *rocket;
extern pfDCS *explodeDcs;

class CaveQuakeTank : public CaveQuakeMonster {

public:

  CaveQuakeTank() : CaveQuakeMonster("models/monsters/tank/tris.md2") {
    initActions();
    //fprintf(stderr, "NUMBER OF ACTIONS: %d\n", anim->getNumActions());
    WALKSPEED = 0.0f; // keep in place for now
    RUNSPEED = 0.0f;
    life = 800;
    lastFrame = 0;
    painCounter = 0;
  }

  virtual void reset() {
    CaveQuakeMonster::reset();
    life = 800;
  }

  virtual void update() {
    int frame = anim->getCurrFrame();
    //if (CAVEBUTTON1) cout << "frame: " << frame << endl;
    if (frame != lastFrame) {

      if (frame == 5)
        quakeSound("tIdle", this->distanceFromEnemy());
      else if (frame == 41 || frame == 48 || frame == 33)
        quakeSound("tFoot", this->distanceFromEnemy());
      else if (frame == 62 || frame == 65 || frame == 68)
        quakeSound("tGun", this->distanceFromEnemy());
      else if (frame == 136 || frame == 139 || frame == 142)
        quakeSound("tRocket", this->distanceFromEnemy());
      else if (frame >= 171 && frame <= 188) {
        int i = rand()%5;
        if (i == 0) quakeSound("tMacha", this->distanceFromEnemy());
        if (i == 1) quakeSound("tMachb", this->distanceFromEnemy());
        if (i == 2) quakeSound("tMachc", this->distanceFromEnemy());
        if (i == 3) quakeSound("tMachd", this->distanceFromEnemy());
        if (i == 4) quakeSound("tMache", this->distanceFromEnemy());
      }

      else if (frame == 117) 
        quakeSound("tLoad", this->distanceFromEnemy());
      //else if (frame == 153)
      //  quakeSound("tReload", this->distanceFromEnemy());
      else if (frame == 226)
        quakeSound("tDeath", this->distanceFromEnemy());
      else if (frame == 249)
        quakeSound("tThud", this->distanceFromEnemy());

      if (frame == 64 || frame == 67 || frame == 70)
        fire(10);
      else if (frame == 138)
        fire(20, 0);
      else if (frame == 141)
        fire(20, 1);
      else if (frame == 144)
        fire(20, 2);
      else if (frame >= 174 && frame <= 180 && frame%2 == 1) 
        fire(4);
      else if (frame == 187 || frame == 189)
        fire(4);

      if (frame >= 30 && frame <= 54) setSpeed(WALKSPEED);
      else setSpeed(0.0);
    }
    lastFrame = frame;

    CaveQuakeMonster::update();
  }

  virtual void initActions() {
    STAND = anim->addAction(0, 29);
    WALK = anim->addAction(30, 54);
    RUN = WALK;
    ATTACK = anim->addAction(55, 76);
    //anim->addAction(77, 114); // weird... don't use
    anim->addAction(115, 167);
    anim->addAction(168, 196);
    PAIN = anim->addAction(197, 200);
    anim->addAction(201, 205);
    anim->addAction(206, 221);
    DEATH = anim->addAction(222, 253);
  }

  virtual void sight() {
    if (mood == M_FRIENDLY)
      quakeSound("tSight", this->distanceFromEnemy());
    CaveQuakeMonster::sight();
  }

  virtual void pain(int which=0) {
    // this guy feels no pain... :)
    painCounter++;
    if (painCounter > 30) {
      painCounter = 0;
      int i=rand()%3;
      anim->playAction(PAIN+i);
      anim->setInterrupt();
      quakeSound("tPain", this->distanceFromEnemy());
    }
  }

  virtual void ai() {
    CaveQuakeMonster::ai();
  
    if (life <= 0) return;
    if (distanceFromEnemy() <= 50.0f) {
      sight();
    }
    if (mood == M_ANGRY) {
      int i = rand()%3;
      attack(i);
    }
  }

  virtual void hit(int damage) {
    life -= damage;

    if (life > 0) {
      if (mood == M_FRIENDLY)
        sight();
      else
        pain();
    }
    else {
      if (anim->getCurrAction() != DEATH)
        death();
      mood = M_DEAD;
      ROTSPEED = 0.0f;
    }
  }

  virtual void fire(int damage, int which=0) {
    if (damage > 15) {
      CaveQuakeBullet *b;
      pfMatrix rotM;
      rotM.makeRot(H, 0.0f, 0.0f, 1.0f);
      pfVec3 gunPos;
      if (which == 0)
        gunPos.xformPt(pfVec3(2.0f, -3.0f, 7.5), rotM);  // pos of gun
      else if (which == 1)
        gunPos.xformPt(pfVec3(2.0f, -2.6f, 7.5), rotM);  // pos of gun
      else
        gunPos.xformPt(pfVec3(2.0f, -2.2f, 7.5), rotM);  // pos of gun
      pfVec3 bulletPos(X, Y, Z);
      bulletPos += gunPos;
      if (inSight() && enemy != NULL) {
        pfVec3 enemyPos(enemy->X, enemy->Y, enemy->Z+4.0f);
        pfVec3 dir = enemyPos - bulletPos;
        dir.normalize();
        b = new CaveQuakeBullet(bulletPos, dir, rocket, explodeDcs, 55.0f, 100, 0.5f, "pRGunX");
      }
      else {
        pfVec3 dir(dx, dy, 0.0f);
        b = new CaveQuakeBullet(bulletPos, dir, rocket, explodeDcs, 55.0f, 100, 0.5f, "pRGunX");
      }
      b->getRoot()->setTravFuncs(PFTRAV_APP, NULL, updateBulletFunc);
      b->getRoot()->setTravData(PFTRAV_APP, b);
      transDcs->addChild(b->getRoot()); // transDcs is extern (caveQuake.cxx
    }
    else if (inSight())
      enemy->hit(damage);
  }
};

#endif
