#include <iostream.h>
#include "pfcaveAlt.h"
#include "pfbox.h"

int CAVE_ESCKEY=0;
int CAVE_RKEY=0, CAVE_DKEY=0, CAVE_QKEY=0, CAVE_ZKEY=0, CAVE_XKEY=0, CAVE_EKEY;

int CAVEBUTTON1=0, CAVEBUTTON2=0, CAVEBUTTON3=0;
int LCAVEBUTTON1=0, LCAVEBUTTON2=0, LCAVEBUTTON3=0;

float CAVE_JOYSTICK_X = 0.0f;
float CAVE_JOYSTICK_Y = 0.0f;
float CAVE_H=0.0f, CAVE_P=0.0f, CAVE_R=0.0f;

void CAVEGetPosition(int type, float *vec) {
  if (type == CAVE_HEAD) {
    float *xyz = BOXGetHeadXYZ();
    vec[0] = xyz[0];
    vec[1] = -xyz[2];
    vec[2] = xyz[1]+4.0;
  }
  if (type == CAVE_WAND) {
    float *xyz = BOXGetWandXYZ();
    vec[0] = xyz[0];
    vec[1] = -xyz[2]+1.0;
    vec[2] = xyz[1];
  }
}

void CAVEGetOrientation(int type, float *vec) {
  vec[0] = CAVE_P;
  vec[1] = CAVE_R;
  vec[2] = CAVE_H;
}

void CAVEGetVector(int type, float *vec) {
  pfMatrix rotM;
  rotM.makeEuler(CAVE_H, CAVE_P, CAVE_R);
  pfVec3 dir;
  dir.xformVec(pfVec3(0.0f, 1.0f, 0.0f), rotM);
  vec[0] = dir[0];
  vec[1] = dir[1];
  vec[2] = dir[2];
}

int CAVEgetbutton(int key) {
  return key;
}

int CAVEButtonChange(int b) {
  if (b == 1 && CAVEBUTTON1 && !LCAVEBUTTON1) return 1;
  if (b == 1 && !CAVEBUTTON1 && LCAVEBUTTON1) return -1;
  if (b == 2 && CAVEBUTTON2 && !LCAVEBUTTON2) return 1;
  if (b == 2 && !CAVEBUTTON2 && LCAVEBUTTON2) return -1;
  if (b == 3 && CAVEBUTTON3 && !LCAVEBUTTON3) return 1;
  if (b == 3 && !CAVEBUTTON3 && LCAVEBUTTON3) return -1;
  return 0;
}

void updateWanda() {
  if (!BOXGetWanda()) return;
  if (BOXGetWandaButton(LEFT)) CAVEBUTTON1 = 1;
  if (BOXGetWandaButton(MIDDLE)) CAVEBUTTON2 = 1;
  if (BOXGetWandaButton(RIGHT)) CAVEBUTTON2 = 1;
  CAVE_JOYSTICK_X = BOXGetWandaAxis(0);
  CAVE_JOYSTICK_Y = BOXGetWandaAxis(1);
  BOXWandaPrintStatus();
}


void updateWing() {
  resetVals();
  float *hpr = BOXGetWandHPR();
  CAVE_H = hpr[0];
  CAVE_P = hpr[1];
  CAVE_R = hpr[2];
  if (!BOXGetWing()) return;

  if (BOXGetWingButton(L1) == PRESSED) CAVEBUTTON1 = 1;
  if (BOXGetWingButton(L1) == HELD)    CAVEBUTTON1 = 1;
  if (BOXGetWingButton(L2) == PRESSED) CAVEBUTTON1 = 1;
  if (BOXGetWingButton(L2) == HELD)    CAVEBUTTON1 = 1;
  if (BOXGetWingButton(R1) == PRESSED) CAVEBUTTON1 = 1; 
  if (BOXGetWingButton(R1) == HELD)    CAVEBUTTON1 = 1; 
  if (BOXGetWingButton(R2) == PRESSED) CAVEBUTTON1 = 1;
  if (BOXGetWingButton(R2) == HELD)    CAVEBUTTON1 = 1;
  if (BOXGetWingButton(A) == PRESSED)  CAVEBUTTON2 = 1;
  if (BOXGetWingButton(B) == PRESSED)  CAVEBUTTON2 = 1;
  if (BOXGetWingButton(C) == PRESSED)  CAVEBUTTON3 = 1;
  if (BOXGetWingButton(X) == PRESSED)  CAVEBUTTON2 = 1;
  if (BOXGetWingButton(Y) == PRESSED)  CAVEBUTTON2 = 1;
  if (BOXGetWingButton(Z) == PRESSED)  CAVEBUTTON3 = 1;
  if (BOXGetWingButton(START) == PRESSED) CAVEBUTTON3 = 1;
  if (BOXGetWingButton(MODE) == PRESSED) {
    CAVEBUTTON1 = 1;
    CAVEBUTTON2 = 1;
    CAVEBUTTON3 = 1;
  }
  float px = BOXGetWingAxis(PAD_X);
  float py = BOXGetWingAxis(PAD_Y);
  float lx = BOXGetWingAxis(LEFT_X);
  float ly = BOXGetWingAxis(LEFT_Y);
  float rx = BOXGetWingAxis(RIGHT_X);
  float ry = BOXGetWingAxis(RIGHT_Y);
  CAVE_JOYSTICK_X = 0.7*px + 0.7*lx + 0.7*rx;
  CAVE_JOYSTICK_Y = 0.7*py + 0.7*ly + 0.7*ry;
}

void resetVals() {
  CAVE_ESCKEY = 0;

  CAVE_RKEY = 0;
  CAVE_DKEY = 0;
  CAVE_QKEY = 0;
  CAVE_ZKEY = 0;
  CAVE_XKEY = 0;
  CAVE_EKEY = 0;

  LCAVEBUTTON1 = CAVEBUTTON1;
  LCAVEBUTTON2 = CAVEBUTTON2;
  LCAVEBUTTON3 = CAVEBUTTON3;
  CAVEBUTTON1 = 0;
  CAVEBUTTON2 = 0;
  CAVEBUTTON3 = 0;
  CAVE_JOYSTICK_X = 0.0f;
  CAVE_JOYSTICK_Y = 0.0f;
}

void keyDown(int ks) {
  switch(ks) {
  case XK_Escape:  CAVE_ESCKEY = 1; break;
  case XK_Return:  CAVEBUTTON1 = 1; break;
  
  case XK_Shift_L:
  case XK_Shift_R: CAVEBUTTON2 = 1; break;
  case XK_Alt_L:
  case XK_Alt_R:   CAVEBUTTON3 = 1; break;

  case XK_Left:  CAVE_JOYSTICK_X = -0.9f; break;
  case XK_Down:  CAVE_JOYSTICK_Y = -0.9f; break;
  case XK_Up:    CAVE_JOYSTICK_Y =  0.9f; break;
  case XK_Right: CAVE_JOYSTICK_X =  0.9f; break;

  case XK_r: CAVE_RKEY = 1; break;
  case XK_d: CAVE_DKEY = 1; break;
  case XK_q: CAVE_QKEY = 1; break;
  case XK_z: CAVE_ZKEY = 1; break;
  case XK_x: CAVE_XKEY = 1; break;
  case XK_e: CAVE_EKEY = 1; break;
  default:
    break;
  }
}

